/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import quek.undergarden.client.model.FixedHumanoidModel;
import quek.undergarden.entity.monster.denizen.Denizen;
import quek.undergarden.registry.UGItems;

public class Denizen2Model<T extends Denizen>
extends FixedHumanoidModel<T> {
    public Denizen2Model(ModelPart part) {
        super(part, 6.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(34, 0).addBox(-4.0f, -5.0f, -8.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 34).addBox(-4.0f, -8.0f, -5.0f, 8.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)2.0f));
        PartDefinition body2 = body.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 16).addBox(-6.0f, -4.0f, -5.0f, 12.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(66, 0).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 24.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)-18.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(66, 0).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 24.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)-18.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(82, 0).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 29.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)-5.0f, (float)2.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(82, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 29.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-5.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void translateToHand(HumanoidArm side, PoseStack stack) {
        float yOffset = 11.0f;
        this.getArm(side).translateAndRotate(stack);
        stack.translate(0.0f, yOffset / 16.0f, 0.0f);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemstack.is(UGItems.SPEAR) && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        }
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
    }
}

