/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.Brute;

public class BruteModel<T extends Brute>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public BruteModel(ModelPart root) {
        this.torso = root.getChild("uppertorso");
        this.head = root.getChild("head");
        this.leftArm = root.getChild("leftarm");
        this.rightArm = root.getChild("rightarm");
        this.leftLeg = root.getChild("leftleg");
        this.rightLeg = root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition uppertorso = partdefinition.addOrReplaceChild("uppertorso", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -7.5f, -4.0f, 14.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(36, 37).addBox(0.0f, -10.5f, 1.0f, 0.0f, 18.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)1.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowertorso = uppertorso.addOrReplaceChild("lowertorso", CubeListBuilder.create().texOffs(36, 29).addBox(-6.0f, -5.9973f, -2.76f, 12.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(46, 60).addBox(0.0f, -5.9973f, 2.24f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.4973f, (float)-1.24f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 14).addBox(-5.0f, -6.0f, -8.0f, 10.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(-3.0f, 0.0f, -8.0f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition horns = head.addOrReplaceChild("horns", CubeListBuilder.create().texOffs(62, 57).addBox(-5.5f, -2.0f, -3.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(16, 58).addBox(3.5f, -2.0f, -3.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-6.0f, (float)1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition horns2 = horns.addOrReplaceChild("horns2", CubeListBuilder.create().texOffs(30, 64).addBox(-5.5f, 1.0f, -5.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 0).addBox(3.5f, 1.0f, -5.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(18, 23).addBox(0.0f, -4.0f, -3.0f, 4.0f, 30.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -4.0f, -3.0f, 4.0f, 30.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 58).addBox(-1.8f, -1.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)10.0f, (float)10.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(54, 46).addBox(-2.2f, -1.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)10.0f, (float)10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableSet.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableSet.of((Object)this.head, (Object)this.torso, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object[])new ModelPart[0]);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }
}

