/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.facade.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.MimicBlockSupport;
import mcjty.xnet.modules.facade.data.MimicData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class FacadeTileEntity
extends GenericTileEntity
implements IFacadeSupport {
    public FacadeTileEntity(BlockPos pos, BlockState state) {
        super(FacadeModule.TYPE_FACADE.get(), pos, state);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        if (this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.requestModelDataUpdate();
        }
    }

    @Override
    public BlockState getMimicBlock() {
        BlockState state = ((MimicData)this.getData(FacadeModule.MIMIC_DATA)).state();
        if (state.isAir()) {
            return null;
        }
        return state;
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(GenericCableBlock.FACADEID, (Object)this.getMimicBlock()).build();
    }

    public void setMimicBlock(@Nonnull BlockState mimicBlock) {
        this.setData(FacadeModule.MIMIC_DATA, new MimicData(mimicBlock));
        this.markDirtyClient();
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        BlockState state = ((MimicData)this.getData(FacadeModule.MIMIC_DATA)).state();
        MimicBlockSupport.writeToNBT(tagCompound, state);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        BlockState state = MimicBlockSupport.readFromNBT(provider, tagCompound);
        if (state == null) {
            state = Blocks.AIR.defaultBlockState();
        }
        this.setData(FacadeModule.MIMIC_DATA, new MimicData(state));
    }
}

