/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.mek;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.config.AFConfig;
import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.energy.forgeenergy.ForgeStrictEnergyHandler;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MekEnergyCap
implements IStrictEnergyHandler {
    private final IStorageService storage;
    private final IActionSource source;
    public static final BlockCapability<IStrictEnergyHandler, Direction> CAP = Capabilities.STRICT_ENERGY.block();

    public static IStrictEnergyHandler of(@Nullable IStorageService storage, IActionSource source) {
        if (storage == null) {
            return new ForgeStrictEnergyHandler((IEnergyStorage)new EnergyStorage(0));
        }
        return new MekEnergyCap(storage, source);
    }

    public static long send(IStrictEnergyHandler handler, IStorageService storage, IActionSource source) {
        long drainedFE;
        long notAddedJ;
        long ioJ = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(AFConfig.getFluxAccessorIO());
        long toAddJ = ioJ - (notAddedJ = handler.insertEnergy(ioJ, Action.SIMULATE));
        long toAddFE = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(toAddJ);
        if (toAddFE > 0L && (drainedFE = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toAddFE, Actionable.MODULATE, source)) > 0L) {
            long drainedJ = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(drainedFE);
            long leftJ = handler.insertEnergy(drainedJ, Action.EXECUTE);
            long leftFE = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(leftJ);
            if (leftFE > 0L) {
                storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), leftFE, Actionable.MODULATE, source);
                return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(drainedJ - leftJ);
            }
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(drainedJ);
        }
        return 0L;
    }

    private MekEnergyCap(IStorageService storage, IActionSource source) {
        this.storage = storage;
        this.source = source;
    }

    public int getEnergyContainerCount() {
        return 1;
    }

    public long getEnergy(int container) {
        if (container == 0) {
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(this.storage.getCachedInventory().get((AEKey)FluxKey.of(EnergyType.FE)));
        }
        return 0L;
    }

    public void setEnergy(int container, long energy) {
    }

    public long getMaxEnergy(int container) {
        if (container == 0) {
            long space = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), 0x7FFFFFFFFFFFFFFEL, Actionable.SIMULATE, this.source);
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(space + this.storage.getCachedInventory().get((AEKey)FluxKey.of(EnergyType.FE)));
        }
        return 0L;
    }

    public long getNeededEnergy(int container) {
        if (container == 0) {
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), 0x7FFFFFFFFFFFFFFEL, Actionable.SIMULATE, this.source));
        }
        return 0L;
    }

    public long insertEnergy(int container, long amount, @NotNull Action action) {
        if (container == 0) {
            return this.insertEnergy(amount, action);
        }
        return amount;
    }

    public long insertEnergy(long amount, Action action) {
        long inserted;
        long toInsert = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(amount);
        if (toInsert > 0L && (inserted = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), toInsert, Actionable.ofSimulate((boolean)action.simulate()), this.source)) > 0L) {
            return amount - UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(inserted);
        }
        return amount;
    }

    public long extractEnergy(int container, long amount, @NotNull Action action) {
        if (container == 0) {
            return this.extractEnergy(amount, action);
        }
        return 0L;
    }

    public long extractEnergy(long amount, Action action) {
        long toExtract = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(amount);
        if (toExtract > 0L) {
            long extracted = this.storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toExtract, Actionable.ofSimulate((boolean)action.simulate()), this.source);
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(extracted);
        }
        return 0L;
    }
}

