/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.energy;

import appeng.api.AECapabilities;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class EnergyCapCache {
    private final Map<BlockCapability<?, Direction>, BlockCapabilityCache<?, Direction>[]> cache = new IdentityHashMap();
    private final Map<Direction, BlockCapabilityCache<IInWorldGridNodeHost, Void>> girdCache = new IdentityHashMap<Direction, BlockCapabilityCache<IInWorldGridNodeHost, Void>>();
    private final ServerLevel world;
    private final BlockPos pos;
    private final Supplier<IGrid> self;

    public EnergyCapCache(ServerLevel world, BlockPos pos, Supplier<IGrid> gridSupplier) {
        this.world = world;
        this.pos = pos;
        this.self = gridSupplier;
    }

    @Nullable
    public <T> T getEnergyCap(BlockCapability<T, Direction> cap, Direction side) {
        if (this.checkGrid(side)) {
            return (T)this.getEnergyCacheInternal(cap, side).getCapability();
        }
        return null;
    }

    private boolean checkGrid(Direction side) {
        IInWorldGridNodeHost gird = (IInWorldGridNodeHost)this.getGridCache(side).getCapability();
        if (gird == null) {
            return true;
        }
        IGrid thisGrid = this.self.get();
        if (thisGrid != null) {
            IGridNode thatGrid = gird.getGridNode(side.getOpposite());
            if (thatGrid == null) {
                return true;
            }
            return thatGrid.getGrid() != thisGrid;
        }
        return true;
    }

    private BlockCapabilityCache<IInWorldGridNodeHost, Void> getGridCache(Direction side) {
        return this.girdCache.computeIfAbsent(side, face -> BlockCapabilityCache.create((BlockCapability)AECapabilities.IN_WORLD_GRID_NODE_HOST, (ServerLevel)this.world, (BlockPos)this.pos.relative(face), null));
    }

    private <T> BlockCapabilityCache<T, Direction> getEnergyCacheInternal(BlockCapability<T, Direction> cap, Direction side) {
        int index;
        BlockCapabilityCache[] capArr = this.cache.computeIfAbsent(cap, __ -> new BlockCapabilityCache[6]);
        if (capArr[index = side.get3DDataValue()] == null) {
            capArr[index] = BlockCapabilityCache.create(cap, (ServerLevel)this.world, (BlockPos)this.pos.relative(side), (Object)side.getOpposite());
        }
        return capArr[index];
    }
}

