/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.machine.QpBlock;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallBedrockModuleRecipe
extends ShapelessRecipe {
    public static final String NAME = "install_bedrock_module_recipe";
    public static final RecipeSerializer<InstallBedrockModuleRecipe> SERIALIZER = new Serializer();
    private final QpBlock block;

    public InstallBedrockModuleRecipe(QpBlock block) {
        super("quarryplus:install_bedrock_module_recipe", CraftingBookCategory.MISC, InstallBedrockModuleRecipe.resultItem(block), InstallBedrockModuleRecipe.getIngredients(block));
        this.block = block;
    }

    InstallBedrockModuleRecipe(ResourceLocation targetBlockId) {
        this(InstallBedrockModuleRecipe.fromId(targetBlockId));
    }

    public boolean matches(CraftingInput input, Level level) {
        if (!super.matches(input, level)) {
            return false;
        }
        ItemStack stack = input.items().stream().filter(s -> s.getItem() == this.block.blockItem).findFirst().map(ItemStack::copy).orElse(ItemStack.EMPTY);
        Boolean installed = (Boolean)stack.getOrDefault(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)Boolean.FALSE);
        return installed == false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = input.items().stream().filter(s -> s.getItem() == this.block.blockItem).findFirst().map(ItemStack::copy).orElse(ItemStack.EMPTY);
        stack.set(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)true);
        return stack;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static QpBlock fromId(ResourceLocation blockId) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
        if (block instanceof QpBlock) {
            QpBlock qpBlock = (QpBlock)block;
            return qpBlock;
        }
        throw new IllegalArgumentException("Invalid block %s(%s)".formatted(block, blockId));
    }

    ResourceLocation getTargetBlockId() {
        return this.block.name;
    }

    @NotNull
    private static NonNullList<Ingredient> getIngredients(QpBlock block) {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{block}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PlatformAccess.getAccess().registerObjects().bedrockModuleItem().get()})});
    }

    static ItemStack resultItem(QpBlock block) {
        ItemStack stack = new ItemStack((ItemLike)block);
        stack.set(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)true);
        return stack;
    }

    public static Builder builder(QpBlock block) {
        return new Builder(block);
    }

    public static final class Builder
    implements RecipeBuilder {
        private final QpBlock block;
        private final RecipeCategory category = RecipeCategory.MISC;
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        public Builder(QpBlock block) {
            this.block = block;
        }

        public Builder unlockedBy(String name, Criterion<?> criterion) {
            this.criteria.put(name, criterion);
            return this;
        }

        public Builder group(@Nullable String groupName) {
            throw new UnsupportedOperationException("Group definition is not supported");
        }

        public Item getResult() {
            return this.block.blockItem;
        }

        public void save(RecipeOutput recipeOutput, ResourceLocation id) {
            Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            InstallBedrockModuleRecipe recipe = new InstallBedrockModuleRecipe(this.block);
            AdvancementHolder advancement = builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/"));
            recipeOutput.accept(id, (Recipe)recipe, advancement);
        }
    }

    private static final class Serializer
    implements RecipeSerializer<InstallBedrockModuleRecipe> {
        public static final MapCodec<InstallBedrockModuleRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(InstallBedrockModuleRecipe::getTargetBlockId, (String)"target", (Codec)ResourceLocation.CODEC)).apply((Applicative)i, InstallBedrockModuleRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InstallBedrockModuleRecipe> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(InstallBedrockModuleRecipe::new, InstallBedrockModuleRecipe::getTargetBlockId).cast();

        private Serializer() {
        }

        public MapCodec<InstallBedrockModuleRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InstallBedrockModuleRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

