/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.misc.SlotContainer;
import com.yogpc.qp.machine.placer.AbstractPlacerTile;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlacerContainer
extends AbstractContainerMenu {
    public static final String PLACER_GUI_NAME = "gui_placer_plus";
    public static final String REMOTE_PLACER_GUI_NAME = "gui_remote_placer";
    public static final String PLACER_GUI_ID = "quarryplus:gui_placer_plus";
    public static final String REMOTE_PLACER_GUI_ID = "quarryplus:gui_remote_placer";
    private static final int PLACER_START_X = 62;
    private static final int REMOTE_PLACER_START_X = 26;
    @NotNull
    final AbstractPlacerTile tile;
    final int startX;

    private PlacerContainer(@Nullable MenuType<?> menuType, int containerId, Player player, BlockPos pos, int startX) {
        super(menuType, containerId);
        this.startX = startX;
        this.tile = (AbstractPlacerTile)Objects.requireNonNull(player.level().getBlockEntity(pos));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new SlotContainer(this.tile, j + i * 3, startX + j * 18, 17 + i * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)player.getInventory(), i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)player.getInventory(), l, 8 + l * 18, 142));
        }
        if (!player.level().isClientSide) {
            this.tile.syncToClient();
        }
    }

    public static PlacerContainer createPlacerContainer(int containerId, Inventory inventory, BlockPos pos) {
        return new PlacerContainer(PlatformAccess.getAccess().registerObjects().placerContainer().get(), containerId, inventory.player, pos, 62);
    }

    public static PlacerContainer createRemotePlacerContainer(int containerId, Inventory inventory, BlockPos pos) {
        return new PlacerContainer(PlatformAccess.getAccess().registerObjects().remotePlacerContainer().get(), containerId, inventory.player, pos, 26);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int allSlots = this.tile.getContainerSize();
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            ItemStack slotContent = remain.copy();
            if (index < allSlots ? !this.moveItemStackTo(remain, allSlots, 36 + allSlots, true) : !this.moveItemStackTo(remain, 0, allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == slotContent.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, remain);
            return slotContent;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.tile.stillValid(player);
    }
}

