/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.exp;

import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.machine.QpItem;
import com.yogpc.qp.machine.exp.ExpModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class ExpModuleItem
extends QpItem
implements QuarryModuleProvider.Item {
    public static final String NAME = "exp_module";

    public ExpModuleItem() {
        super(new Item.Properties().stacksTo(1).component(QuarryDataComponents.HOLDING_EXP_COMPONENT, (Object)0), NAME);
    }

    @Override
    public ExpModule getModule(@NotNull ItemStack stack) {
        return new ExpItemModule(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        int exp;
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide && (exp = ((Integer)stack.getOrDefault(QuarryDataComponents.HOLDING_EXP_COMPONENT, (Object)0)).intValue()) > 0) {
            player.displayClientMessage((Component)Component.literal((String)"Give %d exp point".formatted(exp)), true);
            player.giveExperiencePoints(exp);
            stack.set(QuarryDataComponents.HOLDING_EXP_COMPONENT, (Object)0);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int exp = (Integer)stack.getOrDefault(QuarryDataComponents.HOLDING_EXP_COMPONENT, (Object)0);
        if (exp > 0) {
            tooltipComponents.add((Component)Component.empty().append((Component)Component.literal((String)"Exp: ")).append((Component)Component.literal((String)String.valueOf(exp)).withStyle(ChatFormatting.AQUA)));
        }
    }

    private record ExpItemModule(ItemStack stack) implements ExpModule
    {
        @Override
        public void addExp(int amount) {
            if (amount == 0) {
                return;
            }
            this.stack.update(QuarryDataComponents.HOLDING_EXP_COMPONENT, (Object)0, (Object)amount, Integer::sum);
        }

        @Override
        public int getExp() {
            return (Integer)this.stack.getOrDefault(QuarryDataComponents.HOLDING_EXP_COMPONENT, (Object)0);
        }

        @Override
        public String toString() {
            return "ExpItemModule{exp=" + this.getExp() + "}";
        }
    }
}

