/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.straw;

import com.buuz135.industrial.utils.apihandlers.straw.StrawHandlerBase;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
public class WaterStrawHandler
extends StrawHandlerBase {
    public WaterStrawHandler() {
        super(() -> Fluids.WATER);
    }

    @Override
    public void onDrink(Level world, BlockPos pos, Fluid stack, Player player, boolean fromFluidContainer) {
        player.clearFire();
        CompoundTag tag = player.getPersistentData();
        if (tag.contains("lavaDrink") && world.getGameTime() - tag.getLong("lavaDrink") < 120L) {
            player.spawnAtLocation(new ItemStack((ItemLike)Blocks.OBSIDIAN), player.getEyeHeight());
            tag.putLong("lavaDrink", 0L);
            world.playSound(null, (double)player.blockPosition().getX(), (double)player.blockPosition().getY(), (double)player.blockPosition().getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }
    }
}

