/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.hrznstudio.titanium.util.TagUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class LaserDrillOreRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<LaserDrillOreRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Ingredient.CODEC.fieldOf("output").forGetter(o -> o.output), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(o -> o.catalyst), (App)LaserDrillRarity.CODEC.listOf().fieldOf("rarity").forGetter(o -> o.rarity)).apply((Applicative)in, LaserDrillOreRecipe::new));
    public List<LaserDrillRarity> rarity;
    public Ingredient output;
    public int pointer = 0;
    public Ingredient catalyst;

    public LaserDrillOreRecipe(Ingredient output, Ingredient catalyst, LaserDrillRarity ... rarity) {
        this(output, catalyst, List.of(rarity));
    }

    public LaserDrillOreRecipe(Ingredient output, Ingredient catalyst, List<LaserDrillRarity> rarity) {
        this.output = output;
        this.catalyst = catalyst;
        this.rarity = rarity;
    }

    public LaserDrillOreRecipe() {
    }

    public LaserDrillOreRecipe(Ingredient output, int color, LaserDrillRarity ... rarity) {
        this(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModuleCore.LASER_LENS[color].get()}), rarity);
    }

    public static void init(RecipeOutput output) {
        LaserDrillOreRecipe.createWithDefault(output, (ItemLike)Blocks.COAL_ORE, 15, 5, 132, 10, 4);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/iron", 12, 5, 68, 20, 3);
        LaserDrillOreRecipe.createWithDefault(output, (ItemLike)Blocks.REDSTONE_ORE, 14, 5, 16, 28, 4);
        LaserDrillOreRecipe.createTagRecipe(output, "raw_materials/gold", 4, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(BiomeTags.HAS_MINESHAFT_MESA), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of()), 32, 80, 16), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), 5, 32, 6), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault(output, (ItemLike)Blocks.LAPIS_ORE, 11, 13, 34, 14, 2);
        LaserDrillOreRecipe.createItemRecipe(output, (ItemLike)Blocks.EMERALD_ORE, 5, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(BiomeTags.IS_MOUNTAIN), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of()), 5, 29, 8), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(BiomeTags.IS_MOUNTAIN), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of()), 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault(output, (ItemLike)Blocks.DIAMOND_ORE, 3, 5, 16, 4, 1);
        LaserDrillOreRecipe.createItemRecipe(output, (ItemLike)Blocks.NETHER_QUARTZ_ORE, 0, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), List.of()), 7, 117, 12), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), 0, 255, 1));
        LaserDrillOreRecipe.createItemRecipe(output, (ItemLike)Blocks.GLOWSTONE, 4, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), List.of()), 7, 117, 8), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), 0, 255, 1));
        LaserDrillOreRecipe.createTagRecipe(output, "raw_materials/uranium", 5, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), List.of()), 5, 29, 5), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault(output, "ores/sulfur", 4, 5, 10, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/galena", 10, 15, 30, 6, 1);
        LaserDrillOreRecipe.createTagRecipe(output, "raw_materials/iridium", 0, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.END), List.of()), 5, 68, 8), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault(output, "ores/ruby", 14, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/sapphire", 11, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/peridot", 13, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/sodalite", 11, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/yellorite", 4, 16, 68, 3, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/cinnabar", 14, 30, 70, 2, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/bauxite", 12, 50, 100, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/pyrite", 12, 30, 70, 3, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/cinnabar", 14, 30, 70, 2, 1);
        LaserDrillOreRecipe.createEnd(output, "raw_materials/tungsten", 15, 20, 70, 4);
        LaserDrillOreRecipe.createEnd(output, "raw_materials/sheldonite", 0, 30, 70, 6);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/platinum", 3, 5, 16, 3, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/tetrahedrite", 14, 60, 90, 4, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/tin", 8, 64, 96, 8, 2);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/lead", 10, 10, 40, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/silver", 7, 10, 40, 5, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/copper", 1, 35, 65, 10, 2);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/aluminum", 12, 68, 84, 5, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/nickel", 12, 5, 68, 4, 1);
        LaserDrillOreRecipe.createEnd(output, "ores/draconium", 10, 60, 95, 10);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/yellorium", 4, 16, 68, 3, 1);
        LaserDrillOreRecipe.createNether(output, "raw_materials/cobalt", 11, 34, 96, 8);
        LaserDrillOreRecipe.createNether(output, "raw_materials/ardite", 4, 89, 116, 8);
        LaserDrillOreRecipe.createItemRecipe(output, (ItemLike)Blocks.ANCIENT_DEBRIS, 12, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), List.of()), 1, 20, 1));
        LaserDrillOreRecipe.createWithDefault(output, "ores/niter", 4, 5, 20, 2, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/arcane", 2, 45, 60, 3, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/bitumen", 15, 50, 60, 2, 1);
        LaserDrillOreRecipe.createWithDefault(output, "ores/fluorite", 8, 15, 30, 6, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/osmium", 8, 5, 36, 8, 1);
        LaserDrillOreRecipe.createWithDefault(output, "raw_materials/yellorite", 4, 15, 50, 3, 1);
    }

    public static void createWithDefault(RecipeOutput recipeOutput, ItemLike output, int color, int min, int max, int weight, int defaultWeight) {
        LaserDrillOreRecipe.createItemRecipe(recipeOutput, output, color, LaserDrillOreRecipe.createDefaultRarities(min, max, weight, defaultWeight));
    }

    public static void createWithDefault(RecipeOutput recipeOutput, String name, int color, int min, int max, int weight, int defaultWeight) {
        LaserDrillOreRecipe.createTagRecipe(recipeOutput, name, color, LaserDrillOreRecipe.createDefaultRarities(min, max, weight, defaultWeight));
    }

    private static LaserDrillRarity[] createDefaultRarities(int min, int max, int weight, int defaultWeight) {
        return new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), min, max, weight), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(), List.of(BuiltinDimensionTypes.END)), 0, 255, defaultWeight)};
    }

    public static void createEnd(RecipeOutput recipeOutput, String name, int color, int min, int max, int weight) {
        LaserDrillOreRecipe.createTagRecipe(recipeOutput, name, color, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.END), List.of()), min, max, weight));
    }

    public static void createNether(RecipeOutput recipeOutput, String name, int color, int min, int max, int weight) {
        LaserDrillOreRecipe.createTagRecipe(recipeOutput, name, color, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), List.of()), min, max, weight));
    }

    public static void createItemRecipe(RecipeOutput recipeOutput, ItemLike itemLike, int color, LaserDrillRarity ... rarity) {
        Ingredient output = Ingredient.of((ItemLike[])new ItemLike[]{itemLike});
        LaserDrillOreRecipe recipe = new LaserDrillOreRecipe(output, color, rarity);
        ResourceLocation rl = LaserDrillOreRecipe.generateRL(BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath());
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static void createTagRecipe(RecipeOutput recipeOutput, String tagString, int color, LaserDrillRarity ... rarity) {
        TagKey tag = TagUtil.getItemTag((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)tagString));
        Ingredient output = Ingredient.of((TagKey)tag);
        LaserDrillOreRecipe recipe = new LaserDrillOreRecipe(output, color, rarity);
        ResourceLocation rl = LaserDrillOreRecipe.generateRL(tagString);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(tag))});
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("laser_drill_ore/" + key));
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModuleCore.LASER_DRILL_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.LASER_DRILL_TYPE.get();
    }
}

