/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.fluids.FluidStack;

public class LaserDrillFluidRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<LaserDrillFluidRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)FluidStack.CODEC.fieldOf("output").forGetter(o -> o.output), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(o -> o.catalyst), (App)ResourceLocation.CODEC.fieldOf("entity").forGetter(o -> o.entity), (App)LaserDrillRarity.CODEC.listOf().fieldOf("rarity").forGetter(o -> o.rarity)).apply((Applicative)in, LaserDrillFluidRecipe::new));
    public static ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty");
    public FluidStack output;
    public List<LaserDrillRarity> rarity;
    public int pointer = 0;
    public Ingredient catalyst;
    public ResourceLocation entity;

    public LaserDrillFluidRecipe(FluidStack output, Ingredient catalyst, ResourceLocation entity, List<LaserDrillRarity> rarity) {
        this.output = output;
        this.rarity = rarity;
        this.catalyst = catalyst;
        this.entity = entity;
    }

    public LaserDrillFluidRecipe(FluidStack output, Ingredient catalyst, ResourceLocation entity, LaserDrillRarity ... rarity) {
        this(output, catalyst, entity, Arrays.asList(rarity));
    }

    public LaserDrillFluidRecipe(FluidStack output, int color, ResourceLocation entity, LaserDrillRarity ... rarity) {
        this(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModuleCore.LASER_LENS[color].get()}), entity, rarity);
    }

    public LaserDrillFluidRecipe() {
    }

    public static void init(RecipeOutput output) {
        LaserDrillFluidRecipe.createRecipe(output, "lava", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)Fluids.LAVA, 100), 1, EMPTY, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList<TagKey<Biome>>(), new ArrayList<TagKey<Biome>>()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), new ArrayList<ResourceKey<DimensionType>>()), 5, 20, 8)));
        LaserDrillFluidRecipe.createRecipe(output, "ether", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)ModuleCore.ETHER.getSourceFluid().get(), 10), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wither"), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList<TagKey<Biome>>(), new ArrayList<TagKey<Biome>>()), new LaserDrillRarity.DimensionRarity(new ArrayList<ResourceKey<DimensionType>>(), new ArrayList<ResourceKey<DimensionType>>()), -64, 256, 8)));
        if (ModList.get().isLoaded("pneumaticcraft")) {
            LaserDrillFluidRecipe.createRecipe(output, "oil", "pneumaticcraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)ModFluids.OIL.get(), 50), 15, EMPTY, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(LaserDrillRarity.BiomeRarity.OIL, new ArrayList<TagKey<Biome>>()), new LaserDrillRarity.DimensionRarity(new ArrayList<ResourceKey<DimensionType>>(), new ArrayList<ResourceKey<DimensionType>>()), 20, 60, 8)));
        }
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, String modIdCondition, LaserDrillFluidRecipe recipe) {
        ResourceLocation rl = LaserDrillFluidRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, new ICondition[]{new ModLoadedCondition(modIdCondition)});
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("laser_drill_fluid/" + key));
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModuleCore.LASER_DRILL_FLUID_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get();
    }

    public static CompoundTag createNBT(String name, int amount) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("FluidName", name);
        nbt.putInt("Amount", amount);
        return nbt;
    }
}

