/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.network;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.item.infinity.item.ItemInfinityBackpack;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.InventoryStackLocatorInstance;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class BackpackOpenMessage
extends Message {
    private boolean forceDisable;

    public BackpackOpenMessage(boolean forceDisable) {
        this.forceDisable = forceDisable;
    }

    public BackpackOpenMessage() {
    }

    protected void handleMessage(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player entity = context.player();
            ItemInfinityBackpack.findFirstBackpack(entity).ifPresent(target -> {
                ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(entity, target.getSlot());
                if (stack.getItem() instanceof ItemInfinityBackpack && entity instanceof ServerPlayer) {
                    Object id;
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!stack.has(IFAttachments.INFINITY_BACKPACK_ID)) {
                        id = UUID.randomUUID();
                        BackpackDataManager.getData((LevelAccessor)entity.level()).createBackPack((UUID)id);
                        stack.set(IFAttachments.INFINITY_BACKPACK_ID, (Object)((UUID)id).toString());
                    }
                    id = (String)stack.get(IFAttachments.INFINITY_BACKPACK_ID);
                    if (this.forceDisable) {
                        ItemInfinityBackpack.setPickUpMode(stack, 3);
                        entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_disabled").withStyle(ChatFormatting.RED), true);
                    } else if (entity.isShiftKeyDown()) {
                        int mode = (ItemInfinityBackpack.getPickUpMode(stack) + 1) % 4;
                        ItemInfinityBackpack.setPickUpMode(stack, mode);
                        switch (mode) {
                            case 0: {
                                entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_all").withStyle(ChatFormatting.GREEN), true);
                                return;
                            }
                            case 1: {
                                entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.item_pickup_enabled").withStyle(ChatFormatting.GREEN), true);
                                return;
                            }
                            case 2: {
                                entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.xp_pickup_enabled").withStyle(ChatFormatting.GREEN), true);
                                return;
                            }
                        }
                        entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_disabled").withStyle(ChatFormatting.RED), true);
                    } else {
                        ItemInfinityBackpack.sync(entity.level(), (String)id, serverPlayer);
                        IndustrialForegoing.NETWORK.sendTo((Message)new BackpackOpenedMessage(target.getSlot(), target.getName()), serverPlayer);
                        serverPlayer.openMenu((MenuProvider)((ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get()), buffer -> LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new InventoryStackLocatorInstance(target.getName(), target.getSlot())));
                        return;
                    }
                }
            });
        });
    }
}

