/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.TransporterBlock;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.TransporterModelData;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;

public class TransporterTile
extends ActiveTile<TransporterTile>
implements IBlockContainer<TransporterTypeFactory> {
    @Save
    private SidedInventoryComponent<TransporterTile> augmentInventory;
    private Map<Direction, TransporterType> transporterTypeMap = new HashMap<Direction, TransporterType>();

    public TransporterTile(BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)ModuleTransportStorage.TRANSPORTER.getBlock(), (BlockEntityType)ModuleTransportStorage.TRANSPORTER.type().get(), blockPos, blockState);
        this.augmentInventory = (SidedInventoryComponent)((InventoryComponent)this.getAugmentFactory().create()).setComponentHarness((IComponentHarness)this.getSelf()).setInputFilter((stack, integer) -> AugmentWrapper.isAugment((ItemStack)stack) && this.canAcceptAugment((ItemStack)stack));
        this.addInventory((InventoryComponent)this.augmentInventory);
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.augmentInventory.getFacingModes().put(value, IFacingComponent.FaceMode.NONE);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(this.getAugmentBackground());
    }

    @Nonnull
    public TransporterTile getSelf() {
        return this;
    }

    @Override
    public Level getBlockWorld() {
        return this.level;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.worldPosition;
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public void requestFluidSync() {
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, TransporterTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        int production = 1;
        if (this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING)) {
            production = (int)((float)production + AugmentWrapper.getType((ItemStack)this.getInstalledAugments(ProcessingAddonItem.PROCESSING).getFirst(), (IAugmentType)ProcessingAddonItem.PROCESSING));
        }
        for (int i = 0; i < production; ++i) {
            this.getTransporterTypeMap().values().forEach(TransporterType::update);
        }
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, TransporterTile blockEntity) {
        super.clientTick(level, pos, state, (BlockEntity)blockEntity);
        this.getTransporterTypeMap().values().forEach(TransporterType::updateClient);
    }

    @Override
    public boolean hasUpgrade(Direction facing) {
        return this.transporterTypeMap.containsKey(facing);
    }

    @Override
    public void addUpgrade(Direction facing, TransporterTypeFactory factory) {
        if (!this.hasUpgrade(facing)) {
            this.transporterTypeMap.put(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
            this.requestSync();
            if (this.level.isClientSide) {
                this.getLevel().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
    }

    @Override
    public void removeUpgrade(Direction facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.level.isClientSide && drop) {
                TransporterType upgrade = this.transporterTypeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack);
                    item.setItem(stack);
                    this.level.addFreshEntity((Entity)item);
                }
            }
            this.transporterTypeMap.get(facing).onUpgradeRemoved();
            this.transporterTypeMap.remove(facing);
            this.requestSync();
            if (this.level.isClientSide) {
                this.getLevel().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
        if (this.transporterTypeMap.isEmpty()) {
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        }
    }

    public void openGui(Player player, Direction facing) {
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, packetBuffer -> {
                packetBuffer.writeBlockPos(this.worldPosition);
                packetBuffer.writeEnum((Enum)facing);
            });
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new ContainerTransporter(menu, this, (Direction)((TransporterBlock)ModuleTransportStorage.TRANSPORTER.getBlock()).getFacingUpgradeHit(this.level.getBlockState(this.worldPosition), this.level, this.worldPosition, entityPlayer).getLeft(), inventoryPlayer);
    }

    @Override
    public List<Integer> getEntityFilter() {
        return Collections.emptyList();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(TransporterModelData.UPGRADE_PROPERTY, (Object)new TransporterModelData(new HashMap<Direction, TransporterType>(this.transporterTypeMap))).build();
    }

    public Map<Direction, TransporterType> getTransporterTypeMap() {
        return this.transporterTypeMap;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        CompoundTag upgrades = new CompoundTag();
        for (Direction facing : Direction.values()) {
            if (!this.hasUpgrade(facing)) continue;
            CompoundTag upgradeTag = new CompoundTag();
            TransporterType upgrade = this.getTransporterTypeMap().get(facing);
            upgradeTag.putString("factory", BuiltInRegistries.ITEM.getKey((Object)upgrade.getFactory().getUpgradeItem()).toString());
            CompoundTag customNBT = upgrade.serializeNBT(provider);
            if (customNBT != null) {
                upgradeTag.put("customNBT", (Tag)customNBT);
            }
            upgrades.put(facing.getSerializedName(), (Tag)upgradeTag);
        }
        compoundTag.put("Transporters", (Tag)upgrades);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("Transporters")) {
            CompoundTag upgradesTag = compound.getCompound("Transporters");
            for (Direction facing : Direction.values()) {
                if (!upgradesTag.contains(facing.getSerializedName())) continue;
                CompoundTag upgradeTag = upgradesTag.getCompound(facing.getSerializedName());
                TransporterTypeFactory factory = null;
                for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
                    if (!BuiltInRegistries.ITEM.getKey((Object)transporterTypeFactory.getUpgradeItem()).equals((Object)ResourceLocation.parse((String)upgradeTag.getString("factory")))) continue;
                    factory = transporterTypeFactory;
                    break;
                }
                if (factory == null) continue;
                TransporterType upgrade = this.transporterTypeMap.getOrDefault(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
                if (upgradeTag.contains("customNBT")) {
                    upgrade.deserializeNBT(provider, upgradeTag.getCompound("customNBT"));
                }
                this.transporterTypeMap.put(facing, upgrade);
            }
        }
    }

    public List<ItemStack> getInstalledAugments() {
        return this.getItemStackAugments().stream().filter(AugmentWrapper::isAugment).collect(Collectors.toList());
    }

    public List<ItemStack> getInstalledAugments(IAugmentType filter) {
        return this.getItemStackAugments().stream().filter(AugmentWrapper::isAugment).filter(stack -> AugmentWrapper.hasType((ItemStack)stack, (IAugmentType)filter)).collect(Collectors.toList());
    }

    public boolean hasAugmentInstalled(IAugmentType augmentType) {
        return this.getInstalledAugments(augmentType).size() > 0;
    }

    public IFactory<InventoryComponent<TransporterTile>> getAugmentFactory() {
        return () -> new SidedInventoryComponent("augments", 180, 11, 4, 0).disableFacingAddon().setColor(DyeColor.PURPLE).setSlotLimit(1).setRange(1, 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFactory<? extends IScreenAddon> getAugmentBackground() {
        return () -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, 175, 4, true);
    }

    private List<ItemStack> getItemStackAugments() {
        ArrayList<ItemStack> augments = new ArrayList<ItemStack>();
        for (int i = 0; i < this.augmentInventory.getSlots(); ++i) {
            augments.add(this.augmentInventory.getStackInSlot(i));
        }
        return augments;
    }

    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return !this.hasAugmentInstalled(AugmentTypes.SPEED);
        }
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.EFFICIENCY)) {
            return !this.hasAugmentInstalled(AugmentTypes.EFFICIENCY);
        }
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)ProcessingAddonItem.PROCESSING)) {
            return !this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING);
        }
        return false;
    }

    public SidedInventoryComponent<TransporterTile> getAugmentInventory() {
        return this.augmentInventory;
    }
}

