/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.WashingFactoryConfig;
import com.buuz135.industrial.fluid.OreTitaniumFluidType;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class WashingFactoryTile
extends IndustrialProcessingTile<WashingFactoryTile> {
    @Save
    private SidedInventoryComponent<WashingFactoryTile> input = (SidedInventoryComponent)new SidedInventoryComponent("input", 40, 40, 1, 0).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> {
        if (!stack.is(Tags.Items.RAW_MATERIALS)) {
            return false;
        }
        for (ResourceLocation resourceLocation : stack.getTags().map(TagKey::location).toList()) {
            if (!resourceLocation.toString().startsWith("c:raw_materials/") || !OreTitaniumFluidType.isValid(resourceLocation)) continue;
            return true;
        }
        return false;
    });
    @Save
    private SidedFluidTankComponent<WashingFactoryTile> meatInput;
    @Save
    private SidedFluidTankComponent<WashingFactoryTile> meatOutput;

    public WashingFactoryTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.WASHING_FACTORY, 100, 40, blockPos, blockState);
        this.addInventory((InventoryComponent)this.input);
        this.meatInput = (SidedFluidTankComponent)new SidedFluidTankComponent("meat", WashingFactoryConfig.maxTankSize, 70, 20, 1).setColor(DyeColor.BROWN).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.MEAT.getSourceFluid().get()));
        this.addTank(this.meatInput);
        this.meatOutput = (SidedFluidTankComponent)new SidedFluidTankComponent<WashingFactoryTile>("output", WashingFactoryConfig.maxOutputSize, 135, 20, 2){

            protected void onContentsChanged() {
                WashingFactoryTile.this.syncObject(WashingFactoryTile.this.meatOutput);
            }

            public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
                return Collections.emptyList();
            }
        }.setColor(DyeColor.ORANGE).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank(this.meatOutput);
    }

    @Override
    public boolean canIncrease() {
        if (this.input.getStackInSlot(0).isEmpty()) {
            return false;
        }
        ResourceLocation resourceLocation = ItemStackUtils.getOreTag(this.input.getStackInSlot(0));
        if (resourceLocation == null) {
            return false;
        }
        FluidStack output = OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation);
        return this.meatInput.getFluidAmount() >= 100 && this.meatOutput.fillForced(output, IFluidHandler.FluidAction.SIMULATE) == 100;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            if (!this.input.getStackInSlot(0).isEmpty()) {
                ResourceLocation resourceLocation = ItemStackUtils.getOreTag(this.input.getStackInSlot(0));
                this.meatInput.drainForced(100, IFluidHandler.FluidAction.EXECUTE);
                FluidStack output = OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation);
                this.input.getStackInSlot(0).shrink(1);
                this.meatOutput.fillForced(output, IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    public int getMaxProgress() {
        return WashingFactoryConfig.maxProgress;
    }

    @Override
    protected int getTickPower() {
        return WashingFactoryConfig.powerPerTick;
    }

    @Nonnull
    public WashingFactoryTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<WashingFactoryTile> createEnergyStorage() {
        return new EnergyStorageComponent(WashingFactoryConfig.maxStoredPower, 10, 20);
    }
}

