/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.resourceproduction.tile.LaserDrillTile;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LaserDrillBlock
extends IndustrialBlock<LaserDrillTile> {
    public LaserDrillBlock() {
        super("laser_drill", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), LaserDrillTile.class, ModuleResourceProduction.TAB_RESOURCE);
    }

    public BlockEntityType.BlockEntitySupplier<LaserDrillTile> getTileEntityFactory() {
        return LaserDrillTile::new;
    }

    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.SIX_WAY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level world, BlockPos pos, RandomSource rand) {
        LaserDrillTile tile;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof LaserDrillTile && !(tile = (LaserDrillTile)blockEntity).getTarget().equals((Object)BlockPos.ZERO) && tile.isSpawnParticles()) {
            BlockPos target = tile.getTarget();
            Vec3i vector = tile.getFacingDirection().getOpposite().getNormal();
            Vec3 vec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            vec = vec.add(0.5, 0.5, 0.5).add((double)vector.getX() / 2.0, (double)vector.getY() / 2.0, (double)vector.getZ() / 2.0);
            Vec3 velocity = vec.vectorTo(new Vec3((double)target.getX(), (double)target.getY(), (double)target.getZ()).add(0.5, 0.5, 0.5));
            double vel = 10.0;
            world.addParticle((ParticleOptions)ParticleTypes.END_ROD, vec.x(), vec.y(), vec.z(), velocity.x / vel, velocity.y / vel, velocity.z / vel);
        }
    }

    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("pfp").pattern("bmb").pattern("grg").define(Character.valueOf('p'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('f'), IndustrialTags.Items.GEAR_DIAMOND).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('m'), IndustrialTags.Items.MACHINE_FRAME_SIMPLE).define(Character.valueOf('g'), IndustrialTags.Items.GEAR_GOLD).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).save(consumer);
    }
}

