/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.worlddata.MycelialDataManager;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.GeneratorTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.event.handler.EventManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class MycelialReactorTile
extends IndustrialGeneratorTile<MycelialReactorTile> {
    public static final HashMap<Level, List<BlockPos>> REACTOR_POSITIONS = new HashMap();
    @Save
    private String owner;
    private ProgressBarComponent<MycelialReactorTile> bar;
    private boolean canWork = false;

    public MycelialReactorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleGenerator.MYCELIAL_REACTOR, blockPos, blockState);
    }

    @Nonnull
    public MycelialReactorTile getSelf() {
        return this;
    }

    public int consumeFuel() {
        this.canWork = false;
        this.markForUpdate();
        return 5;
    }

    public boolean canStart() {
        if (this.canWork) {
            return true;
        }
        this.markForUpdate();
        return false;
    }

    public void setCanWork(boolean canWork) {
        this.canWork = canWork;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, MycelialReactorTile blockEntity) {
        super.serverTick(level, pos, state, (GeneratorTile)blockEntity);
        if (!((List)REACTOR_POSITIONS.getOrDefault(this.level, new ArrayList())).contains(this.worldPosition)) {
            REACTOR_POSITIONS.computeIfAbsent(this.level, a -> new ArrayList()).add(this.worldPosition);
        }
    }

    public int getEnergyProducedEveryTick() {
        return 25000000;
    }

    public ProgressBarComponent<MycelialReactorTile> getProgressBar() {
        this.bar = new ProgressBarComponent<MycelialReactorTile>(30, 20, 0, 100){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(30, 20, MycelialReactorTile.this.bar){

                    @OnlyIn(value=Dist.CLIENT)
                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.titanium.progressbar.progress").getString() + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(MycelialReactorTile.this.bar.getProgress()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(MycelialReactorTile.this.bar.getMaxProgress()))));
                        int progress = MycelialReactorTile.this.bar.getMaxProgress() - MycelialReactorTile.this.bar.getProgress();
                        if (!MycelialReactorTile.this.bar.getIncreaseType()) {
                            progress = MycelialReactorTile.this.bar.getMaxProgress() - progress;
                        }
                        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + "ETA: " + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(Math.ceil((double)(progress * MycelialReactorTile.this.bar.getTickingTime()) / 20.0 / (double)MycelialReactorTile.this.bar.getProgressIncrease())) + String.valueOf(ChatFormatting.DARK_AQUA) + "s")));
                        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.industrialforegoing.generating").getString() + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(MycelialReactorTile.this.getEnergyProducedEveryTick()) + String.valueOf(ChatFormatting.DARK_AQUA) + " FE" + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.DARK_AQUA) + "t")));
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
        return this.bar;
    }

    public int getEnergyCapacity() {
        return 100000000;
    }

    public int getExtractingEnergy() {
        return this.getEnergyCapacity();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ProgressBarComponent<MycelialReactorTile> getBar() {
        return this.bar;
    }

    static {
        EventManager.forge(LevelTickEvent.Post.class).process(event -> {
            for (BlockPos reactorPosition : (List)REACTOR_POSITIONS.getOrDefault(event.getLevel(), new ArrayList())) {
                BlockEntity tile = event.getLevel().getBlockEntity(reactorPosition);
                if (!(tile instanceof MycelialReactorTile)) continue;
                MycelialReactorTile reactorTile = (MycelialReactorTile)tile;
                int amount = MycelialDataManager.getReactorAvailable(reactorTile.owner, tile.getLevel(), false).size();
                if (amount != IMycelialGeneratorType.TYPES.size()) continue;
                MycelialDataManager.getReactorAvailable(reactorTile.owner, tile.getLevel(), true);
                reactorTile.setCanWork(true);
            }
            ((List)REACTOR_POSITIONS.getOrDefault(event.getLevel(), new ArrayList())).clear();
        }).subscribe();
    }
}

