/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class ElectricToolBreakSpeedMixin {
    @Unique
    private static final ThreadLocal<Boolean> CAN_OVERRIDE = ThreadLocal.withInitial(() -> true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private static float getDestroyProgressRaw(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        CAN_OVERRIDE.set(false);
        try {
            float f = state.getDestroyProgress(player, level, pos);
            return f;
        }
        finally {
            CAN_OVERRIDE.set(true);
        }
    }

    @Inject(method={"getDestroyProgress"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDestroyProgress(Player player, BlockGetter level, BlockPos pos, CallbackInfoReturnable<Float> callback) {
        ElectricToolItem tool;
        ItemStack stack;
        block3: {
            block2: {
                stack = player.getMainHandItem();
                Item item = stack.getItem();
                if (!(item instanceof ElectricToolItem)) break block2;
                tool = (ElectricToolItem)item;
                if (CAN_OVERRIDE.get().booleanValue()) break block3;
            }
            return;
        }
        tool.getArea(level, player, stack, false).ifPresent(area -> {
            MutableFloat minProgress = new MutableFloat(Float.MAX_VALUE);
            MutableBoolean foundAny = new MutableBoolean(false);
            ElectricToolItem.forEachMineableBlock(level, area, (LivingEntity)player, (blockPos, state) -> {
                float destroyProgress = ElectricToolBreakSpeedMixin.getDestroyProgressRaw(state, player, level, blockPos);
                if ((double)destroyProgress > 1.0E-9) {
                    foundAny.setTrue();
                    minProgress.setValue(Math.min(minProgress.getValue().floatValue(), destroyProgress));
                }
            });
            if (foundAny.isTrue()) {
                callback.setReturnValue((Object)minProgress.getValue());
                callback.cancel();
            }
        });
    }
}

