/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.swedz.tesseract.neoforge.api.Assert;

public final class SingingTeslaCoilComponent
implements IComponent {
    private final MachineBlockEntity machine;
    private int note = -1;

    public SingingTeslaCoilComponent(MachineBlockEntity machine) {
        this.machine = machine;
    }

    public boolean hasNote() {
        return this.note > -1;
    }

    public int getNote() {
        return this.note;
    }

    public float getPitch() {
        return this.hasNote() ? NoteBlock.getPitchFromNote((int)this.note) : 1.0f;
    }

    private int getWorldNote() {
        if (!this.machine.hasLevel()) {
            return -1;
        }
        BlockPos below = this.machine.getBlockPos().below();
        BlockState state = this.machine.getLevel().getBlockState(below);
        return state.is(Blocks.NOTE_BLOCK) ? (Integer)state.getValue((Property)NoteBlock.NOTE) : -1;
    }

    public boolean updateNote() {
        Assert.that((this.machine.hasLevel() && !this.machine.getLevel().isClientSide() ? 1 : 0) != 0);
        int originalNote = this.note;
        this.note = this.getWorldNote();
        return originalNote != this.note;
    }

    public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("singing_note", this.note);
    }

    public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.note = tag.getInt("singing_note");
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
    }
}

