/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.solar.electric;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import aztech.modern_industrialization.util.Simulation;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.item.PhotovoltaicCellItem;

public final class SolarGeneratorComponent
implements IComponent.ServerOnly {
    private final MIInventory inventory;
    private final EnergyComponent energy;
    private final Supplier<Float> energyEfficiency;
    private final Predicate<PhotovoltaicCellItem> photovoltaicCellTest;
    private int tick;
    private PhotovoltaicCellItem photovoltaicCell;
    private boolean usedDistilledWater;

    public SolarGeneratorComponent(MIInventory inventory, EnergyComponent energy, Supplier<Float> energyEfficiency, Predicate<PhotovoltaicCellItem> photovoltaicCellTest) {
        this.inventory = inventory;
        this.energy = energy;
        this.energyEfficiency = energyEfficiency;
        this.photovoltaicCellTest = photovoltaicCellTest;
    }

    private ConfigurableFluidStack getSlotWater() {
        return (ConfigurableFluidStack)this.inventory.getFluidStacks().getFirst();
    }

    private ConfigurableItemStack getSlotPhotovoltaicCell() {
        return (ConfigurableItemStack)this.inventory.getItemStacks().getFirst();
    }

    public long getEnergyPerTick() {
        return this.photovoltaicCell != null ? (long)((double)((float)this.photovoltaicCell.getEuPerTick() * this.energyEfficiency.get().floatValue()) * (this.usedDistilledWater ? 1.5 : 1.0)) : 0L;
    }

    private boolean tryUseDistilledWater() {
        try (Transaction transaction = Transaction.openOuter();){
            boolean usedDistilledWater = this.getSlotWater().extractDirect((TransferVariant)FluidVariant.of((Fluid)EIFluids.DISTILLED_WATER.asFluid()), 1L, (TransactionContext)transaction) > 0L;
            transaction.commit();
            boolean bl = usedDistilledWater;
            return bl;
        }
    }

    private void deterioratePhotovoltaicCell() {
        ConfigurableItemStack slotCell = this.getSlotPhotovoltaicCell();
        ItemStack cellStack = slotCell.toStack();
        this.photovoltaicCell.incrementTick(cellStack);
        if (this.photovoltaicCell.getSolarTicksRemaining(cellStack) > 0) {
            slotCell.setKey((TransferVariant)ItemVariant.of((ItemStack)cellStack));
        } else {
            this.photovoltaicCell = null;
            this.usedDistilledWater = false;
            slotCell.setAmount(0L);
            slotCell.setKey((TransferVariant)ItemVariant.blank());
        }
    }

    public void tick() {
        PhotovoltaicCellItem cellItem;
        Item item;
        ++this.tick;
        if (this.tick > 20) {
            this.tick = 1;
        }
        if ((item = ((ItemVariant)this.getSlotPhotovoltaicCell().getResource()).getItem()) instanceof PhotovoltaicCellItem && this.photovoltaicCellTest.test(cellItem = (PhotovoltaicCellItem)item)) {
            boolean deterioratePhotovoltaicCell;
            this.photovoltaicCell = cellItem;
            this.usedDistilledWater = this.tryUseDistilledWater();
            boolean bl = deterioratePhotovoltaicCell = !this.usedDistilledWater || this.tick % 2 == 0;
            if (deterioratePhotovoltaicCell) {
                this.deterioratePhotovoltaicCell();
            }
            this.energy.insertEu((long)((float)this.getEnergyPerTick() * (this.usedDistilledWater ? 1.5f : 1.0f)), Simulation.ACT);
        } else {
            this.photovoltaicCell = null;
            this.usedDistilledWater = false;
        }
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
    }
}

