/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task.task;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;

public final class TillingFarmerTask
extends FarmerTask {
    public TillingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.TILLING, component);
    }

    private UseOnContext createFakeContext(BlockPos pos) {
        return new UseOnContext(this.level, null, InteractionHand.MAIN_HAND, Items.DIAMOND_HOE.getDefaultInstance(), new BlockHitResult(pos.getBottomCenter().add(0.0, 1.0, 0.0), Direction.UP, pos, false));
    }

    @Override
    protected boolean run() {
        if (!this.tilling || !this.hasWater) {
            return false;
        }
        for (FarmerTile tile : this.blockMap.tiles()) {
            BlockState newState;
            FarmerBlock dirt = tile.dirt();
            BlockPos pos = dirt.pos();
            BlockState state = dirt.state(this.level);
            if (!state.is(BlockTags.DIRT) || (newState = state.getToolModifiedState(this.createFakeContext(pos), ItemAbilities.HOE_TILL, true)) == null || !newState.canSurvive((LevelReader)this.level, pos)) continue;
            dirt.setBlock(this.level, newState, 11, (Holder.Reference<GameEvent>)GameEvent.BLOCK_CHANGE, newState);
            if (!this.operations.operate()) continue;
            return true;
        }
        return this.operations.didOperate();
    }
}

