/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.planting;

import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriState;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantingContext;
import net.swedz.tesseract.neoforge.behavior.Behavior;

public interface FarmerPlantable
extends Behavior<PlantingContext> {
    public static boolean canPlace(PlantingContext context, BlockState state) {
        Level level = context.level();
        FarmerBlock dirt = context.tile().dirt();
        FarmerBlock crop = context.tile().crop();
        BlockState farmland = dirt.state(level);
        BlockState cropState = ((BlockItem)context.stack().getItem()).getBlock().defaultBlockState();
        TriState soilDecision = farmland.canSustainPlant((BlockGetter)level, dirt.pos(), Direction.UP, cropState);
        return soilDecision.isDefault() ? cropState.canSurvive((LevelReader)level, crop.pos()) : soilDecision.isTrue();
    }

    public static BlockState getPlacementState(PlantingContext context, Block block) {
        BlockState state = block.getStateForPlacement(context.placeContext());
        return state != null && FarmerPlantable.canPlace(context, state) ? state : null;
    }

    public static BlockState getPlacementStateBlockItem(PlantingContext context) {
        return FarmerPlantable.getPlacementState(context, ((BlockItem)context.stack().getItem()).getBlock());
    }

    public boolean canPlant(PlantingContext var1);

    public void plant(PlantingContext var1);
}

