/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.hatches.EnergyHatch;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower.TeslaTowerShapes;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower.TeslaTowerTier;
import net.swedz.extended_industrialization.machines.component.itemslot.TeslaTowerUpgradeComponent;
import net.swedz.extended_industrialization.machines.component.tesla.AestheticTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaTransferLimits;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitter;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitterComponent;
import net.swedz.extended_industrialization.machines.guicomponent.EIModularSlotPanelSlots;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.compat.mi.component.SimpleItemStackComponent;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGui;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel.ModularSlotPanel;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.BasicMultiblockMachineBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.machine.multiblock.matcher.SameCableTierShapeMatcher;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MIParser;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;
import org.joml.Vector3f;

public final class TeslaTowerBlockEntity
extends BasicMultiblockMachineBlockEntity
implements EnergyListComponentHolder,
TeslaTransmitter.Delegate,
TeslaBehavior {
    private final RedstoneControlComponent redstoneControl;
    private final TeslaTowerUpgradeComponent upgrade;
    private final List<EnergyComponent> energyInputs = Lists.newArrayList();
    private final TeslaTransmitterComponent transmitter;
    private final AestheticTeslaCoilComponent aesthetic;
    private boolean hasMismatchingHatches;
    private CableTier cableTier;
    private long lastEnergyTransmitted;
    private static final TeslaTowerShapes SHAPES = new TeslaTowerShapes();

    public TeslaTowerBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("tesla_tower"), false).backgroundHeight(200).build(), SHAPES.shapeTemplates());
        this.redstoneControl = new RedstoneControlComponent();
        this.upgrade = new TeslaTowerUpgradeComponent(this::onUpgradeUpdate);
        this.transmitter = new TeslaTransmitterComponent((MachineBlockEntity)this, this.energyInputs, () -> TeslaTransferLimits.of(this.cableTier, (TeslaTowerTier)SHAPES.tiers().get(this.activeShape.getActiveShapeIndex())), () -> new WorldPos(this.level, this.getTopLoadPosition()));
        this.aesthetic = new AestheticTeslaCoilComponent();
        this.registerComponents(new IComponent[]{this.redstoneControl, this.upgrade, this.transmitter, this.aesthetic});
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularMultiblockGui.Server(0, 80, content -> {
            content.add((Component)(this.isShapeValid() ? MIText.MultiblockShapeValid : MIText.MultiblockShapeInvalid).text(), this.isShapeValid() ? 0xFFFFFF : 0xFF0000);
            if (this.isShapeValid()) {
                if (this.hasNetwork()) {
                    TeslaNetwork network = this.getNetwork();
                    if (network.isTransmitterLoaded()) {
                        content.add((Component)EIText.TESLA_NETWORK_TRANSMITTER_RECEIVERS.arg(network.receiverCount()));
                        content.add((Component)EIText.TESLA_NETWORK_TRANSMITTER_TRANSMITTING.arg(this.lastEnergyTransmitted, MITooltips.EU_PER_TICK_PARSER).arg((Object)network.getCableTier(), MIParser.CABLE_TIER_SHORT));
                        long drain = this.getPassiveDrain();
                        content.add((Component)EIText.TESLA_NETWORK_TRANSMITTER_DRAIN.arg(drain, MITooltips.EU_PER_TICK_PARSER));
                        content.add((Component)EIText.TESLA_NETWORK_TRANSMITTER_CONSUMING.arg(this.lastEnergyTransmitted + drain, MITooltips.EU_PER_TICK_PARSER));
                    } else if (this.getCableTier() == null) {
                        content.add((TranslatableTextEnum)EIText.TESLA_TOWER_NO_ENERGY_HATCHES, 0xFF0000);
                    }
                }
            } else if (this.hasMismatchingHatches) {
                content.add((TranslatableTextEnum)EIText.TESLA_TOWER_MISMATCHING_HATCHES, 0xFF0000, true);
            }
        })});
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularSlotPanel.Server((MachineBlockEntity)this, 0).withRedstoneModule(this.redstoneControl).with(EIModularSlotPanelSlots.TESLA_TOWER_UPGRADE, (SimpleItemStackComponent)this.upgrade)});
        ConfigurationPanelBuilder configPanel = new ConfigurationPanelBuilder((Component)EIText.CONFIGURATION_PANEL.text(), (Component)EIText.CONFIGURATION_PANEL_DESCRIPTION.text().withStyle(MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))), (lineIndex, delta) -> this.sync());
        SHAPES.appendConfigurationPanel(configPanel, (MultiblockMachineBlockEntity)this, this.activeShape, true);
        this.aesthetic.appendSelectionPanel((MachineBlockEntity)this, configPanel);
        this.registerGuiComponent(new GuiComponent.Server[]{configPanel.build()});
    }

    private void onUpgradeUpdate(ItemStack from, ItemStack to) {
        if (this.level != null && !this.level.isClientSide()) {
            this.transmitter.getNetwork().updateAll();
        }
    }

    public BlockPos getTopLoadPosition() {
        Direction facing = this.orientation.facingDirection;
        return this.worldPosition.relative(facing, -3).above(14);
    }

    public BlockPos getTopLoadPositionRelative() {
        return this.getTopLoadPosition().subtract((Vec3i)this.worldPosition);
    }

    @Override
    public boolean shouldTeslaRender() {
        return this.isActive.isActive;
    }

    @Override
    public ResourceLocation getTeslaModelLocation() {
        return EI.id("tesla/tesla_tower");
    }

    @Override
    public Vector3f getTeslaColor() {
        return this.aesthetic.getColor();
    }

    public List<? extends EnergyAccess> getEnergyComponents() {
        return this.energyInputs;
    }

    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        if (shapeMatcher.isMatchSuccessful()) {
            CableTier cableTier = null;
            this.energyInputs.clear();
            for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
                hatch.appendEnergyInputs(this.energyInputs);
                if (cableTier != null || !(hatch instanceof EnergyHatch)) continue;
                EnergyHatch energyHatch = (EnergyHatch)hatch;
                cableTier = energyHatch.getCableTier();
            }
            this.cableTier = cableTier;
            if (this.hasNetwork()) {
                if (this.getCableTier() != null) {
                    this.getNetwork().loadTransmitter(this.transmitter);
                }
            } else {
                EI.LOGGER.error("Failed to load transmitter into the network because no network was set yet");
            }
        } else if (this.hasNetwork()) {
            this.getNetwork().unloadTransmitter();
        } else {
            EI.LOGGER.error("Failed to unload transmitter into the network because no network was set yet");
        }
    }

    @Override
    public TeslaTransmitter getDelegateTransmitter() {
        return this.transmitter;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.setNetwork(new WorldPos(level, this.worldPosition));
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.upgrade.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.aesthetic.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public ShapeMatcher createShapeMatcher() {
        return new SameCableTierShapeMatcher(this.level, this.worldPosition, this.orientation.facingDirection, this.getActiveShape(), value -> {
            this.hasMismatchingHatches = value;
        });
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).removeTesla(this.worldPosition);
            return;
        }
        if (this.hasNetwork()) {
            this.getNetwork().unloadTransmitter();
        } else {
            EI.LOGGER.error("Failed to unload transmitter into the network because no network was set yet");
        }
    }

    public void tick() {
        long amountToDrain;
        long drained;
        super.tick();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).tickTesla(this.worldPosition);
            return;
        }
        this.lastEnergyTransmitted = 0L;
        boolean active = false;
        if (this.shapeValid.shapeValid && this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this) && (drained = this.extractEnergy(amountToDrain = this.getPassiveDrain(), false)) == amountToDrain) {
            this.lastEnergyTransmitted = this.transmitEnergy(this.getMaxTransfer());
            active = true;
        }
        this.updateActive(active);
    }

    public List<Component> getTooltips() {
        return List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_TOWER_HELP_1), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_TOWER_HELP_2), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_TOWER_HELP_3));
    }

    public static void registerTieredShapes() {
        SHAPES.register();
    }

    public static Map<ResourceLocation, TeslaTowerTier> getTiersByWinding() {
        return SHAPES.tiersByBlock();
    }
}

