/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.sound;

import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public final class TeslaCoilLoopSound
extends AbstractTickableSoundInstance {
    private final Supplier<Boolean> shouldStop;
    private final Supplier<Float> getPitch;
    private final Runnable onStop;

    public TeslaCoilLoopSound(BlockPos origin, SoundEvent sound, SoundSource source, Supplier<Boolean> shouldStop, Supplier<Float> getPitch, Runnable onStop) {
        super(sound, source, SoundInstance.createUnseededRandom());
        Vec3 pos = origin.getCenter();
        this.x = pos.x();
        this.y = pos.y();
        this.z = pos.z();
        this.looping = true;
        this.volume = 0.0f;
        this.shouldStop = shouldStop;
        this.getPitch = getPitch;
        this.onStop = onStop;
    }

    public void tick() {
        if (this.isStopped()) {
            return;
        }
        if (this.shouldStop.get().booleanValue()) {
            this.stop();
            this.onStop.run();
            return;
        }
        this.volume = 1.0f;
        this.pitch = this.getPitch.get().floatValue();
    }

    public boolean canStartSilent() {
        return true;
    }
}

