/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.ber.tesla.behavior;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.client.ber.tesla.arc.TeslaArcBuilder;
import net.swedz.extended_industrialization.client.model.tesla.TeslaBakedModel;
import net.swedz.extended_industrialization.client.model.tesla.TeslaUnbakedModel;
import net.swedz.tesseract.neoforge.api.Assert;

public final class TeslaArcInstance {
    public static final Random RANDOM = new Random();
    private final Vec3 worldPosition;
    private final Supplier<Direction> facingDirection;
    private final Supplier<TeslaBakedModel> tesla;
    private final List<TeslaArcBuilder> trails = Lists.newArrayList();

    public TeslaArcInstance(BlockPos worldPosition, Supplier<Direction> facingDirection, Supplier<TeslaBakedModel> tesla) {
        Assert.notNull((Object)worldPosition);
        Assert.notNull(facingDirection);
        Assert.notNull(tesla);
        this.worldPosition = worldPosition.getCenter();
        this.facingDirection = facingDirection;
        this.tesla = tesla;
    }

    private TeslaBakedModel tesla() {
        return this.tesla.get();
    }

    public Vec3 closestOrigin(Vec3 target) {
        Vec3 closest = null;
        double closestDistance = 0.0;
        for (Vec3 origin : this.tesla().arcs().worldOrigins(this.worldPosition, this.facingDirection.get())) {
            double distance = origin.distanceTo(target);
            if (closest != null && !(distance < closestDistance)) continue;
            closest = origin;
            closestDistance = distance;
        }
        return closest;
    }

    public List<TeslaArcBuilder> getTrails() {
        return Collections.unmodifiableList(this.trails);
    }

    private void createArc(Vec3 worldOrigin, Vec3 target, int duration, int segments, int segmentSplits) {
        TeslaArcBuilder builder = TeslaArcBuilder.create(duration);
        Vec3 origin = worldOrigin.subtract(this.worldPosition).add(0.5, 0.5, 0.5);
        Vec3 direction = target.subtract(worldOrigin).normalize();
        double distance = worldOrigin.distanceTo(target);
        double segmentLength = distance / (double)segments;
        Vec3 offset = direction.scale(segmentLength);
        for (int i = 0; i < segments; ++i) {
            Vec3 direct = direction.scale(segmentLength * (double)i).add(origin);
            Vec3 tangent = i == segments - 1 ? Vec3.ZERO : TeslaArcInstance.randomTangent(RANDOM, direction).scale((double)this.tesla().arcs().randomVariance(RANDOM));
            tangent = tangent.add(offset);
            double x = direct.x();
            double y = direct.y();
            double z = direct.z();
            for (int j = 0; j < segmentSplits; ++j) {
                builder.add(new Vec3(x, y, z));
                x += tangent.x() / (double)segmentSplits;
                y += tangent.y() / (double)segmentSplits;
                z += tangent.z() / (double)segmentSplits;
            }
        }
        this.trails.add(builder);
    }

    public void createArc(Vec3 origin, Vec3 target) {
        TeslaUnbakedModel.Arcs arcs = this.tesla().arcs();
        this.createArc(origin, target, arcs.duration(), RANDOM.nextInt(arcs.minSegments(), arcs.maxSegments() + 1), arcs.segmentSplits());
    }

    private static Vec3 randomTangent(Random random, Vec3 vector) {
        Vec3 normal = vector.normalize();
        Vec3 tangent = normal.cross(new Vec3(-normal.z(), normal.x(), normal.y()));
        Vec3 bitangent = normal.cross(tangent);
        double angle = random.nextDouble(-Math.PI, Math.PI);
        return tangent.scale(Math.sin(angle)).add(bitangent.scale(Math.cos(angle)));
    }

    public void tick() {
        this.trails.removeIf(trail -> {
            trail.tick();
            return trail.points().isEmpty();
        });
        TeslaBakedModel tesla = this.tesla();
        TeslaUnbakedModel.Arcs arcs = tesla.arcs();
        if (arcs != null) {
            if (arcs.attachesToNearbyEntities()) {
                ClientLevel level = Minecraft.getInstance().level;
                AABB box = arcs.worldNearbyEntitiesBounds(this.worldPosition, this.facingDirection.get());
                List entities = level.getEntities((Entity)null, box, entity -> entity.isAlive() && entity instanceof LivingEntity && !(entity instanceof Player));
                for (Entity entity2 : entities) {
                    Vec3 target = entity2.getBoundingBox().getCenter();
                    this.createArc(this.closestOrigin(target), target);
                }
            }
            if (arcs.hasRandomBounds() && this.trails.size() < arcs.count()) {
                int maxCreate = arcs.count() - this.trails.size();
                int create = Math.max(Math.min(arcs.count() / 2, maxCreate), 1);
                for (int i = 0; i < create; ++i) {
                    Vec3 target = tesla.arcs().worldRandomPointInBounds(RANDOM, this.worldPosition, this.facingDirection.get());
                    this.createArc(this.closestOrigin(target), target);
                }
            }
        }
    }
}

