/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.ber.tesla.arc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.client.ber.tesla.arc.TeslaArcPoint;
import org.joml.Vector4f;

public final class TeslaArcBuilder {
    private final List<TeslaArcPoint> points = Lists.newArrayList();
    public final Supplier<Integer> duration;

    private TeslaArcBuilder(Supplier<Integer> duration) {
        this.duration = duration;
    }

    public static TeslaArcBuilder create(int duration) {
        return TeslaArcBuilder.create(() -> duration);
    }

    public static TeslaArcBuilder create(Supplier<Integer> duration) {
        return new TeslaArcBuilder(duration);
    }

    public List<TeslaArcPoint> points() {
        return this.points;
    }

    public List<TeslaArcPoint> points(float lerp) {
        ArrayList lerpedTeslaArcPoints = Lists.newArrayList();
        int size = this.points.size();
        if (size > 1) {
            for (int i = 0; i < size - 2; ++i) {
                lerpedTeslaArcPoints.add(this.points.get(i).lerp(this.points.get(i + 1), lerp));
            }
        }
        return lerpedTeslaArcPoints;
    }

    public TeslaArcBuilder add(Vec3 point) {
        return this.add(new TeslaArcPoint(point, 0));
    }

    public TeslaArcBuilder add(TeslaArcPoint point) {
        this.points.add(point);
        return this;
    }

    public TeslaArcBuilder tick() {
        int trailDuration = this.duration.get();
        this.points.forEach(TeslaArcPoint::tick);
        this.points.removeIf(point -> point.timeActive() > trailDuration);
        return this;
    }

    public List<Vector4f> build() {
        return this.points.stream().map(TeslaArcPoint::matrixPosition).collect(Collectors.toList());
    }
}

