/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.swedz.extended_industrialization.client.nanosuit.NanoArmorLayer;
import net.swedz.extended_industrialization.client.nanosuit.NanoArmorModel;
import net.swedz.extended_industrialization.client.nanosuit.decorations.MeowNanoSuitDecorationModel;
import net.swedz.extended_industrialization.client.nanosuit.decorations.NanoSuitDecorationModel;
import net.swedz.extended_industrialization.client.nanosuit.decorations.WingNanoSuitDecorationModel;

@EventBusSubscriber(modid="extended_industrialization", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class EIClientModels {
    private static NanoArmorModel NANO_ARMOR_INNER;
    private static NanoArmorModel NANO_ARMOR_OUTER;
    private static List<NanoSuitDecorationModel> NANO_ARMOR_DECORATIONS;

    @SubscribeEvent
    private static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(NanoArmorModel.INNER_LAYER, () -> NanoArmorModel.createLayer(LayerDefinitions.INNER_ARMOR_DEFORMATION));
        event.registerLayerDefinition(NanoArmorModel.OUTER_LAYER, () -> NanoArmorModel.createLayer(LayerDefinitions.OUTER_ARMOR_DEFORMATION));
        event.registerLayerDefinition(WingNanoSuitDecorationModel.LAYER, WingNanoSuitDecorationModel::createLayer);
        event.registerLayerDefinition(MeowNanoSuitDecorationModel.LAYER, MeowNanoSuitDecorationModel::createLayer);
    }

    private static void addGlobalLayer(EntityRenderersEvent.AddLayers event, Function<LivingEntityRenderer, RenderLayer> layer, Predicate<LivingEntityRenderer> rendererFilter) {
        LivingEntityRenderer renderer;
        EntityRenderer entityRenderer;
        for (EntityType entityType : event.getEntityTypes()) {
            entityRenderer = event.getRenderer(entityType);
            if (!(entityRenderer instanceof LivingEntityRenderer) || !rendererFilter.test(renderer = (LivingEntityRenderer)entityRenderer)) continue;
            renderer.addLayer(layer.apply(renderer));
        }
        for (PlayerSkin.Model skin : event.getSkins()) {
            entityRenderer = event.getSkin(skin);
            if (!(entityRenderer instanceof LivingEntityRenderer)) continue;
            renderer = (LivingEntityRenderer)entityRenderer;
            renderer.addLayer(layer.apply(renderer));
        }
    }

    @SubscribeEvent
    private static void registerEntityLayers(EntityRenderersEvent.AddLayers event) {
        EntityRendererProvider.Context context = event.getContext();
        NANO_ARMOR_INNER = new NanoArmorModel(context.bakeLayer(NanoArmorModel.INNER_LAYER));
        NANO_ARMOR_OUTER = new NanoArmorModel(context.bakeLayer(NanoArmorModel.OUTER_LAYER));
        NANO_ARMOR_DECORATIONS = Lists.newArrayList();
        NANO_ARMOR_DECORATIONS.add(new WingNanoSuitDecorationModel(context.bakeLayer(WingNanoSuitDecorationModel.LAYER)));
        NANO_ARMOR_DECORATIONS.add(new MeowNanoSuitDecorationModel(context.bakeLayer(MeowNanoSuitDecorationModel.LAYER)));
        NANO_ARMOR_DECORATIONS = Collections.unmodifiableList(NANO_ARMOR_DECORATIONS);
        EIClientModels.addGlobalLayer(event, r -> new NanoArmorLayer(r, NANO_ARMOR_INNER, NANO_ARMOR_OUTER, NANO_ARMOR_DECORATIONS, context.getModelManager()), r -> r.getModel() instanceof HumanoidModel);
    }
}

