/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.items;

import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.datacomponents.EnergyData;
import de.maxhenkel.pipez.datacomponents.FluidData;
import de.maxhenkel.pipez.datacomponents.GasData;
import de.maxhenkel.pipez.datacomponents.ItemData;
import de.maxhenkel.pipez.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class UpgradeItem
extends Item {
    public static final Component CONFIGURED_ITEM_TOOLTIP = Component.translatable((String)"tooltip.pipez.upgrade.configured.item");
    public static final Component CONFIGURED_ENERGY_TOOLTIP = Component.translatable((String)"tooltip.pipez.upgrade.configured.energy");
    public static final Component CONFIGURED_FLUID_TOOLTIP = Component.translatable((String)"tooltip.pipez.upgrade.configured.fluid");
    public static final Component CONFIGURED_GAS_TOOLTIP = Component.translatable((String)"tooltip.pipez.upgrade.configured.gas");
    private final Upgrade tier;

    public UpgradeItem(Upgrade tier) {
        super(new Item.Properties());
        this.tier = tier;
    }

    public Upgrade getTier() {
        return this.tier;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        GasData gasData;
        FluidData fluidData;
        EnergyData energyData;
        super.appendHoverText(stack, context, tooltip, flagIn);
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        ItemData itemData = (ItemData)stack.get(ModItems.ITEM_DATA_COMPONENT);
        if (itemData != null) {
            list.add(CONFIGURED_ITEM_TOOLTIP.copy());
        }
        if ((energyData = (EnergyData)stack.get(ModItems.ENERGY_DATA_COMPONENT)) != null) {
            list.add(CONFIGURED_ENERGY_TOOLTIP.copy());
        }
        if ((fluidData = (FluidData)stack.get(ModItems.FLUID_DATA_COMPONENT)) != null) {
            list.add(CONFIGURED_FLUID_TOOLTIP.copy());
        }
        if ((gasData = (GasData)stack.get(ModItems.GAS_DATA_COMPONENT)) != null) {
            list.add(CONFIGURED_GAS_TOOLTIP.copy());
        }
        if (!list.isEmpty()) {
            MutableComponent types = (MutableComponent)list.stream().reduce((text1, text2) -> text1.append(", ").append((Component)text2)).get();
            tooltip.add((Component)Component.translatable((String)"tooltip.pipez.upgrade.configured", (Object[])new Object[]{types.withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.YELLOW));
        }
    }
}

