/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.corelib.tag.TagUtils;
import de.maxhenkel.pipez.gui.CycleIconButton;
import de.maxhenkel.pipez.gui.FilterContainer;
import de.maxhenkel.pipez.gui.FilterList;
import de.maxhenkel.pipez.items.FilterDestinationToolItem;
import de.maxhenkel.pipez.net.OpenExtractMessage;
import de.maxhenkel.pipez.net.UpdateFilterMessage;
import de.maxhenkel.pipez.utils.GasUtils;
import de.maxhenkel.pipez.utils.NbtUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterScreen
extends ScreenBase<FilterContainer> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"pipez", (String)"textures/gui/container/filter.png");
    private EditBox item;
    private EditBox nbt;
    private CycleIconButton nbtButton;
    private CycleIconButton invertButton;
    private Button submitButton;
    private Button cancelButton;
    private ScreenBase.HoverArea itemHoverArea;
    private ScreenBase.HoverArea itemTextHoverArea;
    private ScreenBase.HoverArea nbtTextHoverArea;
    private ScreenBase.HoverArea exactNBTHoverArea;
    private ScreenBase.HoverArea invertHoverArea;
    private ScreenBase.HoverArea destinationHoverArea;
    private ScreenBase.HoverArea destinationTextHoverArea;
    private Filter<?, ?> filter;

    public FilterScreen(FilterContainer container, Inventory playerInventory, Component title) {
        super(BACKGROUND, container, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.filter = ((FilterContainer)this.getMenu()).getFilter();
    }

    protected void init() {
        super.init();
        this.hoverAreas.clear();
        this.clearWidgets();
        List<CycleIconButton.Icon> nbtIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 16), new CycleIconButton.Icon(BACKGROUND, 192, 16));
        this.nbtButton = new CycleIconButton(this.leftPos + 125, this.topPos + 81, nbtIcons, () -> this.filter.isExactMetadata() ? 1 : 0, button -> this.filter.setExactMetadata(!this.filter.isExactMetadata()));
        this.addRenderableWidget((GuiEventListener)this.nbtButton);
        List<CycleIconButton.Icon> invertIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 32), new CycleIconButton.Icon(BACKGROUND, 192, 32));
        this.invertButton = new CycleIconButton(this.leftPos + 149, this.topPos + 81, invertIcons, () -> this.filter.isInvert() ? 1 : 0, button -> this.filter.setInvert(!this.filter.isInvert()));
        this.addRenderableWidget((GuiEventListener)this.invertButton);
        this.cancelButton = Button.builder((Component)Component.translatable((String)"message.pipez.filter.cancel"), button -> PacketDistributor.sendToServer((CustomPacketPayload)new OpenExtractMessage(((FilterContainer)this.getMenu()).getIndex()), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + 25, this.topPos + 105, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.submitButton = Button.builder((Component)Component.translatable((String)"message.pipez.filter.submit"), button -> PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFilterMessage(this.filter, ((FilterContainer)this.menu).getIndex()), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + 91, this.topPos + 105, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.submitButton);
        this.item = new EditBox(this.font, this.leftPos + 30, this.topPos + 18, 138, 16, (Component)Component.empty());
        this.item.setTextColor(ChatFormatting.WHITE.getColor().intValue());
        this.item.setBordered(true);
        this.item.setMaxLength(1024);
        if (this.filter.getTag() != null) {
            if (this.filter.getTag() instanceof SingleElementTag) {
                this.item.setValue(this.filter.getTag().getName().toString());
            } else {
                this.item.setValue("#" + this.filter.getTag().getName().toString());
            }
        }
        this.item.setResponder(this::onItemTextChanged);
        this.item.setFilter(s -> {
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            return ResourceLocation.tryParse((String)s) != null;
        });
        this.addRenderableWidget((GuiEventListener)this.item);
        this.nbt = new EditBox(this.font, this.leftPos + 8, this.topPos + 50, 160, 16, (Component)Component.empty());
        this.nbt.setTextColor(ChatFormatting.WHITE.getColor().intValue());
        this.nbt.setBordered(true);
        this.nbt.setMaxLength(1024);
        this.nbt.setValue(this.filter.getMetadata() != null ? this.filter.getMetadata().toString() : "");
        this.nbt.setResponder(this::onNbtTextChanged);
        this.nbt.visible = this.hasNBT();
        this.addRenderableWidget((GuiEventListener)this.nbt);
        this.nbtButton.active = this.filter.getMetadata() != null;
        this.itemHoverArea = new ScreenBase.HoverArea(8, 18, 16, 16, () -> {
            List<Object> tooltip = new ArrayList();
            AbstractStack<?> stack = FilterList.getStack(this.filter);
            if (stack != null) {
                tooltip = stack.getTooltip();
                if (this.filter.getTag() != null && !(this.filter.getTag() instanceof SingleElementTag)) {
                    tooltip.add(Component.translatable((String)"tooltip.pipez.filter.accepts_tag", (Object[])new Object[]{Component.literal((String)this.filter.getTag().getName().toString()).withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.GRAY));
                }
            }
            return tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.itemHoverArea);
        this.itemTextHoverArea = new ScreenBase.HoverArea(29, 17, 140, 18, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"tooltip.pipez.filter.item_tag.description"));
            return tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.itemTextHoverArea);
        this.nbtTextHoverArea = new ScreenBase.HoverArea(7, 49, 162, 18, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.hasNBT()) {
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter.nbt_string.description"));
            } else {
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter.nbt_string.no_nbt"));
            }
            return tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.nbtTextHoverArea);
        this.exactNBTHoverArea = new ScreenBase.HoverArea(126, 82, 20, 20, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.filter.isExactMetadata()) {
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter.nbt.exact"));
            } else {
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter.nbt.not_exact"));
            }
            return tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.exactNBTHoverArea);
        this.invertHoverArea = new ScreenBase.HoverArea(150, 82, 20, 20, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.filter.isInvert()) {
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter.inverted"));
            } else {
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter.not_inverted"));
            }
            return tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.invertHoverArea);
        this.destinationHoverArea = new ScreenBase.HoverArea(8, 83, 16, 16, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"tooltip.pipez.filter.destination.description"));
            if (this.filter.getDestination() != null) {
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter.destination.click_to_remove").withStyle(ChatFormatting.GRAY));
            }
            return tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.destinationHoverArea);
        this.destinationTextHoverArea = new ScreenBase.HoverArea(25, 82, 96, 18, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.filter.getDestination() != null) {
                DirectionalPosition dst = this.filter.getDestination();
                tooltip.add(Component.translatable((String)"tooltip.pipez.filter_destination_tool.destination", (Object[])new Object[]{this.number(dst.getPos().getX()), this.number(dst.getPos().getY()), this.number(dst.getPos().getZ()), Component.translatable((String)("message.pipez.direction." + dst.getDirection().getName())).withStyle(ChatFormatting.DARK_GREEN)}));
            }
            return tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.destinationTextHoverArea);
    }

    private boolean hasNBT() {
        return !(this.filter instanceof GasFilter);
    }

    protected void containerTick() {
        super.containerTick();
        this.submitButton.active = this.filter.getTag() != null || this.filter.getMetadata() != null;
    }

    public void onItemTextChanged(String text) {
        if (text.trim().isEmpty()) {
            this.nbt.setTextColor(ChatFormatting.WHITE.getColor().intValue());
            return;
        }
        if (this.filter instanceof ItemFilter) {
            Tag<Item> tag = TagUtils.getItem(text, true);
            this.filter.setTag(tag);
            if (this.filter.getTag() == null) {
                this.item.setTextColor(ChatFormatting.DARK_RED.getColor().intValue());
            } else {
                this.item.setTextColor(ChatFormatting.WHITE.getColor().intValue());
            }
        } else if (this.filter instanceof FluidFilter) {
            Tag<Fluid> tag = TagUtils.getFluid(text, true);
            this.filter.setTag(tag);
            if (this.filter.getTag() == null) {
                this.item.setTextColor(ChatFormatting.DARK_RED.getColor().intValue());
            } else {
                this.item.setTextColor(ChatFormatting.WHITE.getColor().intValue());
            }
        } else if (this.filter instanceof GasFilter) {
            this.filter.setTag(GasUtils.getGas(text, true));
            if (this.filter.getTag() == null) {
                this.item.setTextColor(ChatFormatting.DARK_RED.getColor().intValue());
            } else {
                this.item.setTextColor(ChatFormatting.WHITE.getColor().intValue());
            }
        }
    }

    public void onNbtTextChanged(String text) {
        if (text.trim().isEmpty()) {
            this.nbt.setTextColor(ChatFormatting.WHITE.getColor().intValue());
            this.nbtButton.active = false;
            this.filter.setExactMetadata(false);
            this.filter.setMetadata(null);
            return;
        }
        this.nbtButton.active = true;
        try {
            this.filter.setMetadata(TagParser.parseTag((String)text));
            this.nbt.setTextColor(ChatFormatting.WHITE.getColor().intValue());
        }
        catch (CommandSyntaxException e) {
            this.nbt.setTextColor(ChatFormatting.DARK_RED.getColor().intValue());
            this.filter.setMetadata(null);
        }
    }

    public void onInsertStack(ItemStack stack) {
        ChemicalStack gas;
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (this.filter instanceof ItemFilter) {
            this.item.setValue(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
            this.nbt.setValue(NbtUtils.componentPatchToNbtOptional(stack.getComponentsPatch()).map(CompoundTag::toString).orElse(""));
        } else if (this.filter instanceof FluidFilter) {
            FluidUtil.getFluidContained((ItemStack)stack).ifPresent(this::onInsertStack);
        } else if (this.filter instanceof GasFilter && (gas = GasUtils.getGasContained(stack)) != null) {
            this.onInsertStack(gas);
        }
    }

    public void onInsertStack(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (this.filter instanceof FluidFilter) {
            this.item.setValue(BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()).toString());
            this.nbt.setValue(NbtUtils.componentPatchToNbtOptional(stack.getComponentsPatch()).map(CompoundTag::toString).orElse(""));
        }
    }

    public void onInsertStack(ChemicalStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (this.filter instanceof GasFilter) {
            this.item.setValue(stack.getChemical().getRegistryName().toString());
            this.nbt.setValue("");
        }
    }

    public void onInsertDestination(ItemStack stack) {
        if (stack == null || !(stack.getItem() instanceof FilterDestinationToolItem)) {
            this.filter.setDestination(null);
            return;
        }
        DirectionalPosition dst = FilterDestinationToolItem.getDestination(stack);
        this.filter.setDestination(dst);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"message.pipez.filter.item_tag"), 8, 7, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"message.pipez.filter.nbt_string"), 8, 39, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"message.pipez.filter.destination"), 8, 71, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle.getVisualOrderText(), 8.0f, (float)(this.imageHeight - 96 + 3), 0x404040, false);
        this.drawHoverAreas(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        AbstractStack<?> stack = FilterList.getStack(this.filter);
        if (stack != null) {
            stack.render(guiGraphics, this.leftPos + 8, this.topPos + 18);
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)(this.leftPos + 31), (double)(this.topPos + 89), 0.0);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        if (this.filter.getDestination() != null) {
            DirectionalPosition dst = this.filter.getDestination();
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"message.pipez.filter_destination_tool.destination", (Object[])new Object[]{this.number(dst.getPos().getX()), this.number(dst.getPos().getY()), this.number(dst.getPos().getZ()), Component.literal((String)String.valueOf(dst.getDirection().name().charAt(0))).withStyle(ChatFormatting.DARK_GREEN)}), 0, 0, 0xFFFFFF, false);
        } else {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"message.pipez.filter_destination_tool.destination.any"), 0, 0, 0xFFFFFF, false);
        }
        guiGraphics.pose().popPose();
        if (this.itemHoverArea.isHovered(this.leftPos, this.topPos, mouseX, mouseY)) {
            this.drawHoverSlot(guiGraphics, this.leftPos + 8, this.topPos + 18);
        }
        if (this.destinationHoverArea.isHovered(this.leftPos, this.topPos, mouseX, mouseY)) {
            this.drawHoverSlot(guiGraphics, this.leftPos + 8, this.topPos + 83);
        }
    }

    private MutableComponent number(int num) {
        return Component.literal((String)String.valueOf(num)).withStyle(ChatFormatting.DARK_GREEN);
    }

    private void drawHoverSlot(GuiGraphics guiGraphics, int posX, int posY) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.fillGradient(posX, posY, posX + 16, posY + 16, this.slotColor, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Slot sl;
        if (this.itemHoverArea.isHovered(this.leftPos, this.topPos, (int)mouseX, (int)mouseY)) {
            if (FilterScreen.hasShiftDown()) {
                this.item.setValue("");
                this.filter.setTag(null);
            } else {
                this.onInsertStack(((FilterContainer)this.getMenu()).getCarried());
            }
            return true;
        }
        if (this.destinationHoverArea.isHovered(this.leftPos, this.topPos, (int)mouseX, (int)mouseY)) {
            this.onInsertDestination(((FilterContainer)this.getMenu()).getCarried());
            return true;
        }
        if (FilterScreen.hasShiftDown() && (sl = this.getSlotUnderMouse()) != null) {
            this.onInsertStack(sl.getItem());
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return this.item.keyPressed(key, scanCode, modifiers) || this.item.canConsumeInput() || this.nbt.keyPressed(key, scanCode, modifiers) || this.nbt.canConsumeInput() || super.keyPressed(key, scanCode, modifiers);
    }

    public void resize(Minecraft mc, int x, int y) {
        String itemTxt = this.item.getValue();
        String nbtTxt = this.nbt.getValue();
        this.init(mc, x, y);
        this.item.setValue(itemTxt);
        this.nbt.setValue(nbtTxt);
    }
}

