/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2importexportcard.item;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.ids.AEComponents;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.util.ConfigInventory;
import appeng.util.inv.AppEngInternalInventory;
import com.ultramega.ae2importexportcard.AE2ImportExportCard;
import com.ultramega.ae2importexportcard.registry.ModDataComponents;
import com.ultramega.ae2importexportcard.util.CardConfigManager;
import com.ultramega.ae2importexportcard.util.UpgradeType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class UpgradeHost
implements IConfigurableObject {
    public final ConfigInventory filterConfig = ConfigInventory.configTypes((int)18).changeListener(this::updateFilter).build();
    private IConfigManager configManager;
    private final UpgradeType type;
    private final Player player;
    private final ItemStack itemStack;
    private ItemStack upgradeStack;

    public UpgradeHost(UpgradeType type, int id, Inventory inventory, WirelessTerminalMenuHost<?> host) {
        this.type = type;
        this.player = inventory.player;
        this.itemStack = host.getItemStack();
        ItemContainerContents upgrades = (ItemContainerContents)this.itemStack.getOrDefault(AEComponents.UPGRADES, (Object)ItemContainerContents.EMPTY);
        for (int i = 0; i < upgrades.getSlots(); ++i) {
            ItemStack stack = upgrades.getStackInSlot(i);
            if (!AE2ImportExportCard.isImportOrExportCard(type, stack)) continue;
            this.upgradeStack = stack;
            this.configManager = CardConfigManager.builder(type, this.itemStack, stack).registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL).build();
            this.filterConfig.readFromChildTag((CompoundTag)stack.getOrDefault(ModDataComponents.FILTER_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)this.player.registryAccess());
        }
    }

    private void updateFilter() {
        ItemContainerContents upgrades = (ItemContainerContents)this.itemStack.getOrDefault(AEComponents.UPGRADES, (Object)ItemContainerContents.EMPTY);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < upgrades.getSlots(); ++i) {
            ItemStack stack = upgrades.getStackInSlot(i);
            if (AE2ImportExportCard.isImportOrExportCard(this.type, stack)) {
                CompoundTag tag = (CompoundTag)stack.getOrDefault(ModDataComponents.FILTER_CONFIG, (Object)new CompoundTag());
                this.filterConfig.writeToChildTag(tag, "", (HolderLookup.Provider)this.player.registryAccess());
                stack.set(ModDataComponents.FILTER_CONFIG, (Object)tag);
            }
            stacks.add(stack);
        }
        this.itemStack.set(AEComponents.UPGRADES, (Object)ItemContainerContents.fromItems(stacks));
    }

    public void setSelectedInventorySlots(int[] selectedInventorySlots) {
        ItemContainerContents upgrades = (ItemContainerContents)this.itemStack.getOrDefault(AEComponents.UPGRADES, (Object)ItemContainerContents.EMPTY);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < upgrades.getSlots(); ++i) {
            ItemStack stack = upgrades.getStackInSlot(i);
            if (AE2ImportExportCard.isImportOrExportCard(this.type, stack)) {
                stack.set(ModDataComponents.SELECTED_INVENTORY_SLOTS, (Object)new IntArrayList(selectedInventorySlots));
            }
            stacks.add(stack);
        }
        this.itemStack.set(AEComponents.UPGRADES, (Object)ItemContainerContents.fromItems(stacks));
    }

    public int[] getSelectedInventorySlots() {
        ItemContainerContents upgrades = (ItemContainerContents)this.itemStack.getOrDefault(AEComponents.UPGRADES, (Object)ItemContainerContents.EMPTY);
        for (int i = 0; i < upgrades.getSlots(); ++i) {
            ItemStack stack = upgrades.getStackInSlot(i);
            if (!AE2ImportExportCard.isImportOrExportCard(this.type, stack)) continue;
            return ((IntList)stack.getOrDefault(ModDataComponents.SELECTED_INVENTORY_SLOTS, (Object)new IntArrayList(new int[36]))).toIntArray();
        }
        return new int[36];
    }

    public IUpgradeInventory getUpgrades() {
        return UpgradeInventories.forItem((ItemStack)this.upgradeStack, (int)(this.type == UpgradeType.EXPORT ? 3 : 2), this::onUpgradesChanged);
    }

    private void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        if (upgrades instanceof AppEngInternalInventory) {
            AppEngInternalInventory internalInventory = (AppEngInternalInventory)upgrades;
            stack.set(AEComponents.UPGRADES, (Object)internalInventory.toItemContainerContents());
        }
        ItemContainerContents itemContainerContents = (ItemContainerContents)this.itemStack.getOrDefault(AEComponents.UPGRADES, (Object)ItemContainerContents.EMPTY);
        ArrayList<ItemStack> newUpgrades = new ArrayList<ItemStack>();
        for (int i = 0; i < itemContainerContents.getSlots(); ++i) {
            ItemStack currentStack = itemContainerContents.getStackInSlot(i);
            if (currentStack.is(stack.getItem())) {
                newUpgrades.add(stack);
                continue;
            }
            newUpgrades.add(currentStack);
        }
        this.itemStack.set(AEComponents.UPGRADES, (Object)ItemContainerContents.fromItems(newUpgrades));
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }
}

