/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.component.ComponentFunctions;
import dev.latvian.mods.kubejs.component.ItemComponentFunctions;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.item.MutableToolTier;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.TickDuration;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import org.jetbrains.annotations.Nullable;

@Info(value="Invoked after all items are registered to modify them.\n")
public class ItemModificationKubeEvent
implements KubeEvent {
    @Info(value="Modifies items matching the given ingredient.\n\n**NOTE**: tag ingredients are not supported at this time.\n")
    public void modify(ItemPredicate in, Consumer<ItemModifications> c) {
        in.kjs$getItemTypes().stream().map(ItemModifications::new).forEach(c);
    }

    @RemapPrefixForJS(value="kjs$")
    public record ItemModifications(Item item) implements ItemComponentFunctions
    {
        @HideFromJS
        public static final Map<Item, Long> BURN_TIME_OVERRIDES = new IdentityHashMap<Item, Long>();

        @Override
        public DataComponentMap kjs$getComponentMap() {
            return this.item.components();
        }

        @Override
        @HideFromJS
        public <T> ComponentFunctions kjs$override(DataComponentType<T> type, @Nullable T value) {
            this.item.kjs$overrideComponent(type, value);
            return this;
        }

        public void setBurnTime(TickDuration i) {
            BURN_TIME_OVERRIDES.put(this.item, i.ticks());
        }

        public void setCraftingRemainder(Item item) {
            this.item.kjs$setCraftingRemainder(item);
        }

        public void setTier(Consumer<MutableToolTier> c) {
            Item item = this.item;
            if (!(item instanceof TieredItem)) {
                throw new IllegalArgumentException("Item is not a tool/tiered item!");
            }
            TieredItem tiered = (TieredItem)item;
            tiered.tier = (Tier)Util.make((Object)new MutableToolTier(tiered.tier), c);
        }

        public void setNameKey(String key) {
            this.item.kjs$setNameKey(key);
        }

        public void disableRepair() {
            this.item.kjs$setCanRepair(false);
        }
    }
}

