/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.LogType;
import dev.latvian.mods.kubejs.util.TimeJS;
import java.awt.Desktop;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class KubeJSErrorScreen
extends Screen {
    public final Screen lastScreen;
    public final ScriptType scriptType;
    public final Path logFile;
    public final List<ConsoleLine> errors;
    public final List<ConsoleLine> warnings;
    public final boolean canClose;
    public List<ConsoleLine> viewing;
    private ErrorList list;

    public KubeJSErrorScreen(Screen lastScreen, ScriptType scriptType, @Nullable Path logFile, List<ConsoleLine> errors, List<ConsoleLine> warnings, boolean canClose) {
        super((Component)Component.empty());
        this.lastScreen = lastScreen;
        this.scriptType = scriptType;
        this.logFile = logFile;
        this.errors = errors;
        this.warnings = warnings;
        this.canClose = canClose;
        this.viewing = errors.isEmpty() && !warnings.isEmpty() ? warnings : errors;
    }

    public KubeJSErrorScreen(Screen lastScreen, ConsoleJS console, boolean canClose) {
        this(lastScreen, console.scriptType, console.scriptType.getLogFile(), new ArrayList<ConsoleLine>(console.errors), new ArrayList<ConsoleLine>(console.warnings), canClose);
    }

    public Component getNarrationMessage() {
        return Component.literal((String)("There were KubeJS " + this.scriptType.name + " errors!"));
    }

    protected void init() {
        super.init();
        this.list = new ErrorList(this, this.minecraft, this.width, this.height, 32, this.height - 32, this.viewing);
        this.addWidget((GuiEventListener)this.list);
        int i = this.height - 26;
        if (CommonProperties.get().startupErrorReportUrl.isBlank()) {
            openLog = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Open Log File"), this::openLog).bounds(this.width / 2 - 155, i, 150, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)(this.canClose ? "Close" : "Quit")), this::quit).bounds(this.width / 2 - 155 + 160, i, 150, 20).build());
        } else {
            openLog = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Open Log File"), this::openLog).bounds(this.width / 4 - 55, i, 100, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Report"), this::report).bounds(this.width / 2 - 50, i, 100, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)(this.canClose ? "Close" : "Quit")), this::quit).bounds(this.width * 3 / 4 - 45, i, 100, 20).build());
        }
        openLog.active = this.logFile != null;
        Button viewOther = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)(this.viewing == this.errors ? "View Warnings [" + this.warnings.size() + "]" : "View Errors [" + this.errors.size() + "]")), this::viewOther).bounds(this.width - 107, 7, 100, 20).build());
        if (this.errors.isEmpty() || this.warnings.isEmpty()) {
            viewOther.active = false;
        }
    }

    private void quit(Button button) {
        if (this.canClose) {
            this.onClose();
        } else {
            this.minecraft.stop();
        }
    }

    private void report(Button button) {
        this.handleComponentClicked(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, CommonProperties.get().startupErrorReportUrl)));
    }

    private void openLog(Button button) {
        if (this.logFile != null) {
            this.handleComponentClicked(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.logFile.toAbsolutePath().toString())));
        }
    }

    private void viewOther(Button button) {
        this.viewing = this.viewing == this.errors ? this.warnings : this.errors;
        this.repositionElements();
    }

    public void render(GuiGraphics guiGraphics, int mx, int my, float delta) {
        super.render(guiGraphics, mx, my, delta);
        this.list.render(guiGraphics, mx, my, delta);
        guiGraphics.drawCenteredString(this.font, "KubeJS " + this.scriptType.name + " script " + (this.viewing == this.errors ? "errors" : "warnings"), this.width / 2, 12, 0xFFFFFF);
        if (this.errors.isEmpty() && this.warnings.isEmpty()) {
            guiGraphics.drawCenteredString(this.font, "No errors or warnings found!", this.width / 2, this.height / 2 - 6, 0x66FF66);
        }
    }

    public boolean shouldCloseOnEsc() {
        return this.canClose;
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public static class ErrorList
    extends ObjectSelectionList<Entry> {
        public final KubeJSErrorScreen screen;
        public final List<ConsoleLine> lines;

        public ErrorList(KubeJSErrorScreen screen, Minecraft minecraft, int width, int height, int top, int bottom, List<ConsoleLine> lines) {
            super(minecraft, width, bottom - top, top, 48);
            this.screen = screen;
            this.lines = lines;
            Calendar calendar = Calendar.getInstance();
            for (int i = 0; i < lines.size(); ++i) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(this, minecraft, i, lines.get(i), calendar));
            }
        }

        public boolean keyPressed(int i, int j, int k) {
            Entry sel;
            if (CommonInputs.selected((int)i) && (sel = (Entry)this.getSelected()) != null) {
                sel.open();
                return true;
            }
            return super.keyPressed(i, j, k);
        }

        public int getRowWidth() {
            return (int)((double)this.width * 0.93);
        }
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final ErrorList errorList;
        private final Minecraft minecraft;
        private final ConsoleLine line;
        private long lastClickTime;
        private final FormattedCharSequence indexText;
        private final FormattedCharSequence scriptLineText;
        private final FormattedCharSequence timestampText;
        private final List<FormattedCharSequence> errorText;
        private final List<FormattedCharSequence> stackTraceText;

        public Entry(ErrorList errorList, Minecraft minecraft, int index, ConsoleLine line, Calendar calendar) {
            this.errorList = errorList;
            this.minecraft = minecraft;
            this.line = line;
            this.indexText = Component.literal((String)("#" + (index + 1))).getVisualOrderText();
            ArrayList<SourceLine> sourceLines = new ArrayList<SourceLine>(line.sourceLines);
            ArrayList<String> scriptLineTextList = new ArrayList<String>();
            for (int i = 0; i < sourceLines.size(); ++i) {
                if (sourceLines.get(i).source().endsWith(".java")) continue;
                if (i >= 3) {
                    scriptLineTextList.add("...");
                    break;
                }
                scriptLineTextList.add(sourceLines.get(i).toString());
            }
            if (scriptLineTextList.isEmpty()) {
                scriptLineTextList.add(this.line.type == LogType.WARN ? "Internal Warning" : "Internal Error");
            }
            this.scriptLineText = Component.literal((String)String.join((CharSequence)" < ", scriptLineTextList)).getVisualOrderText();
            StringBuilder sb = new StringBuilder();
            calendar.setTimeInMillis(line.timestamp);
            TimeJS.appendTimestamp(sb, calendar);
            this.timestampText = Component.literal((String)sb.toString()).getVisualOrderText();
            this.errorText = new ArrayList<FormattedCharSequence>(minecraft.font.split((FormattedText)Component.literal((String)line.message), errorList.getRowWidth()).stream().limit(3L).toList());
            this.stackTraceText = line.stackTrace.isEmpty() ? List.of() : minecraft.font.split((FormattedText)Component.literal((String)String.join((CharSequence)"\n", line.stackTrace)).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)), Integer.MAX_VALUE);
        }

        public Component getNarration() {
            return Component.empty();
        }

        public void render(GuiGraphics g, int idx, int y, int x, int w, int h, int mx, int my, boolean hovered, float delta) {
            int col = this.line.type == LogType.ERROR ? 16735075 : 0xFFBB5B;
            g.drawString(this.minecraft.font, this.indexText, x + 1, y + 1, col);
            g.drawCenteredString(this.minecraft.font, this.scriptLineText, x + w / 2, y + 1, 0xFFFFFF);
            g.drawString(this.minecraft.font, this.timestampText, x + w - this.minecraft.font.width(this.timestampText) - 4, y + 1, 0x666666);
            for (int i = 0; i < this.errorText.size(); ++i) {
                g.drawString(this.minecraft.font, this.errorText.get(i), x + 1, y + 13 + i * 10, col);
            }
            if (hovered && !this.stackTraceText.isEmpty()) {
                if (my < y + 10 && this.line.sourceLines.size() >= 3) {
                    ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                    for (SourceLine line : this.line.sourceLines) {
                        lines.add(Component.empty().append((Component)Component.literal((String)line.source()).kjs$gray()).append("#" + line.line()).getVisualOrderText());
                    }
                    this.errorList.screen.setTooltipForNextRenderPass(lines);
                } else {
                    this.errorList.screen.setTooltipForNextRenderPass(Screen.hasShiftDown() ? this.stackTraceText : this.stackTraceText.stream().limit(4L).toList());
                }
            }
        }

        public boolean mouseClicked(double d, double e, int i) {
            this.errorList.setSelected((AbstractSelectionList.Entry)this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                if (i == 1) {
                    this.minecraft.keyboardHandler.setClipboard(String.join((CharSequence)"\n", this.line.stackTrace));
                } else {
                    this.open();
                }
                return true;
            }
            this.lastClickTime = Util.getMillis();
            return true;
        }

        private String fixSource(@Nullable String source) {
            int c;
            if (source != null && !source.isEmpty() && (c = source.indexOf(58)) >= 0) {
                return source.substring(c + 1);
            }
            return source;
        }

        public void open() {
            Path path;
            Object object = this.line.externalFile == null ? (this.line.sourceLines.isEmpty() || this.line.sourceLines.iterator().next().source().isEmpty() ? null : this.line.console.scriptType.path.resolve(this.fixSource(this.line.sourceLines.iterator().next().source()))) : (path = this.line.externalFile);
            if (path != null && Files.exists(path, new LinkOption[0])) {
                try {
                    if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                        throw new IllegalStateException("Error");
                    }
                    Desktop.getDesktop().browseFileDirectory(path.toFile());
                }
                catch (Exception ignored) {
                    if (Files.isRegularFile(path, new LinkOption[0]) && !path.getFileName().toString().endsWith(".js")) {
                        path = path.getParent();
                    }
                    this.errorList.screen.handleComponentClicked(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.toAbsolutePath().toString())));
                }
            }
        }
    }
}

