/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder;
import dev.latvian.mods.kubejs.block.drop.BlockDrops;
import dev.latvian.mods.kubejs.client.ModelGenerator;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

@ReturnsSelf
public class DoorBlockBuilder
extends ShapedBlockBuilder {
    public static final ResourceLocation[] TRAPDOOR_TAGS = new ResourceLocation[]{BlockTags.TRAPDOORS.location()};
    private static final Map<String, ResourceLocation> MODELS = Map.of("top_right", ResourceLocation.withDefaultNamespace((String)"block/door_top_right"), "top_right_open", ResourceLocation.withDefaultNamespace((String)"block/door_top_right_open"), "top_left", ResourceLocation.withDefaultNamespace((String)"block/door_top_left"), "top_left_open", ResourceLocation.withDefaultNamespace((String)"block/door_top_left_open"), "bottom_right", ResourceLocation.withDefaultNamespace((String)"block/door_bottom_right"), "bottom_right_open", ResourceLocation.withDefaultNamespace((String)"block/door_bottom_right_open"), "bottom_left", ResourceLocation.withDefaultNamespace((String)"block/door_bottom_left"), "bottom_left_open", ResourceLocation.withDefaultNamespace((String)"block/door_bottom_left_open"));
    public transient BlockSetType behaviour;

    public DoorBlockBuilder(ResourceLocation i) {
        super(i, new String[0]);
        this.renderType(BlockRenderType.CUTOUT);
        this.noValidSpawns(true);
        this.notSolid();
        this.tagBoth(TRAPDOOR_TAGS);
        this.textures.put("top", this.newID("block/", "_top").toString());
        this.textures.put("bottom", this.newID("block/", "_bottom").toString());
        this.hardness(3.0f);
        this.behaviour = BlockSetType.OAK;
    }

    public DoorBlockBuilder behaviour(BlockSetType wt) {
        this.behaviour = wt;
        return this;
    }

    @Override
    public Block createObject() {
        return new DoorBlock(this.behaviour, this.createProperties());
    }

    @Override
    protected void generateBlockState(VariantBlockStateGenerator bs) {
        Map<DoubleBlockHalf, Map<DoorHingeSide, Map<Boolean, ResourceLocation>>> modelMap = Map.of(DoubleBlockHalf.UPPER, Map.of(DoorHingeSide.RIGHT, Map.of(Boolean.FALSE, this.newID("block/", "_top_right"), Boolean.TRUE, this.newID("block/", "_top_right_open")), DoorHingeSide.LEFT, Map.of(Boolean.FALSE, this.newID("block/", "_top_left"), Boolean.TRUE, this.newID("block/", "_top_left_open"))), DoubleBlockHalf.LOWER, Map.of(DoorHingeSide.RIGHT, Map.of(Boolean.FALSE, this.newID("block/", "_bottom_right"), Boolean.TRUE, this.newID("block/", "_bottom_right_open")), DoorHingeSide.LEFT, Map.of(Boolean.FALSE, this.newID("block/", "_bottom_left"), Boolean.TRUE, this.newID("block/", "_bottom_left_open"))));
        Map<Direction, Map<DoorHingeSide, Map<Boolean, Integer>>> rotationMap = Map.of(Direction.EAST, Map.of(DoorHingeSide.RIGHT, Map.of(Boolean.FALSE, 0, Boolean.TRUE, 270), DoorHingeSide.LEFT, Map.of(Boolean.FALSE, 0, Boolean.TRUE, 90)), Direction.NORTH, Map.of(DoorHingeSide.RIGHT, Map.of(Boolean.FALSE, 270, Boolean.TRUE, 180), DoorHingeSide.LEFT, Map.of(Boolean.FALSE, 270, Boolean.TRUE, 0)), Direction.SOUTH, Map.of(DoorHingeSide.RIGHT, Map.of(Boolean.FALSE, 90, Boolean.TRUE, 0), DoorHingeSide.LEFT, Map.of(Boolean.FALSE, 90, Boolean.TRUE, 180)), Direction.WEST, Map.of(DoorHingeSide.RIGHT, Map.of(Boolean.FALSE, 180, Boolean.TRUE, 90), DoorHingeSide.LEFT, Map.of(Boolean.FALSE, 180, Boolean.TRUE, 270)));
        DoubleBlockHalf[] halfValues = DoubleBlockHalf.values();
        List<Boolean> openValues = List.of(Boolean.TRUE, Boolean.FALSE);
        Collection facingValues = BlockStateProperties.HORIZONTAL_FACING.getPossibleValues();
        DoorHingeSide[] hingeValues = DoorHingeSide.values();
        for (DoubleBlockHalf half : halfValues) {
            for (Boolean open : openValues) {
                for (Direction facing : facingValues) {
                    for (DoorHingeSide hinge : hingeValues) {
                        bs.variant("facing=" + facing.getSerializedName() + ",half=" + half.getSerializedName() + ",hinge=" + hinge.getSerializedName() + ",open=" + open, v -> v.model((ResourceLocation)((Map)((Map)modelMap.get(half)).get(hinge)).get(open)).y((Integer)((Map)((Map)rotationMap.get(facing)).get(hinge)).get(open)));
                    }
                }
            }
        }
    }

    @Override
    protected void generateBlockModels(KubeAssetGenerator generator) {
        String topTexture = (String)this.textures.get("top");
        String bottomTexture = (String)this.textures.get("bottom");
        for (Map.Entry<String, ResourceLocation> entry : MODELS.entrySet()) {
            generator.blockModel(this.newID("", "_" + entry.getKey()), m -> {
                m.parent((ResourceLocation)entry.getValue());
                m.texture("top", topTexture);
                m.texture("bottom", bottomTexture);
            });
        }
    }

    @Override
    public LootTable generateLootTable() {
        BlockDrops blockDrops;
        BlockDrops blockDrops2 = blockDrops = this.drops == null ? BlockDrops.createDefault(((Block)this.get()).asItem().getDefaultInstance()) : this.drops.get();
        if (blockDrops.items().length == 0) {
            return null;
        }
        LootPool.Builder pool = new LootPool.Builder();
        if (blockDrops.rolls() != null) {
            pool.setRolls(blockDrops.rolls());
        }
        pool.when(ExplosionCondition.survivesExplosion());
        for (ItemStack drop : blockDrops.items()) {
            LootPoolSingletonContainer.Builder item = LootItem.lootTableItem((ItemLike)drop.getItem());
            item.when((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)this.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)));
            if (drop.getCount() > 1) {
                item.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)drop.getCount())));
            }
            if (!drop.isComponentsPatchEmpty()) {
                item.apply((LootItemFunction.Builder)LootItemConditionalFunction.simpleBuilder(c -> new SetComponentsFunction(c, drop.getComponentsPatch())));
            }
            pool.add((LootPoolEntryContainer.Builder)item);
        }
        return new LootTable.Builder().withPool(pool).build();
    }

    @Override
    protected void generateItemModel(ModelGenerator m) {
        m.parent(KubeAssetGenerator.GENERATED_ITEM_MODEL);
        m.texture("layer0", this.id.withPath(ID.ITEM).toString());
    }
}

