/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mcjty.lib.crafting.CopyComponentsRecipeBuilder;
import mcjty.lib.crafting.IRecipeBuilder;
import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.lib.datagen.BaseBlockTagsProvider;
import mcjty.lib.datagen.BaseItemModelProvider;
import mcjty.lib.datagen.BaseLootTableProvider;
import mcjty.lib.datagen.BaseRecipeProvider;
import mcjty.lib.datagen.Dob;
import mcjty.lib.datagen.IRecipeFactory;
import mcjty.lib.datagen.ITagFactory;
import net.minecraft.Util;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.data.JsonCodecProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGen {
    private final String modid;
    private final GatherDataEvent event;
    private final List<Dob> dobs = new ArrayList<Dob>();
    private final Map<String, CodecProvider> codecProviders = new HashMap<String, CodecProvider>();

    public DataGen(String modid, GatherDataEvent event) {
        this.modid = modid;
        this.event = event;
    }

    public void addCodecProvider(String name, String directory, Codec codec) {
        this.codecProviders.put(name, new CodecProvider(directory, codec));
    }

    public void add(Dob.Builder ... builder) {
        for (Dob.Builder b : builder) {
            this.dobs.add(b.build());
        }
    }

    public void generate() {
        DataGenerator generator = this.event.getGenerator();
        generator.addProvider(this.event.includeServer(), (DataProvider)new GlobalLootModifierProvider(generator.getPackOutput(), this.event.getLookupProvider(), this.modid){

            protected void start() {
                for (Dob dob : DataGen.this.dobs) {
                    for (Map.Entry<String, Supplier<IGlobalLootModifier>> entry : dob.glmSupplier().entrySet()) {
                        this.add(entry.getKey(), entry.getValue().get(), new ICondition[0]);
                    }
                }
            }
        });
        for (Map.Entry<String, CodecProvider> entry : this.codecProviders.entrySet()) {
            for (Dob dob : this.dobs) {
                HolderLookup.Provider provider2 = dob.holderLookupSupplier().get(entry.getKey());
                generator.addProvider(this.event.includeServer(), (DataProvider)new JsonCodecProvider(this, generator.getPackOutput(), PackOutput.Target.DATA_PACK, entry.getValue().directory(), PackType.SERVER_DATA, entry.getValue().codec(), CompletableFuture.completedFuture(provider2), this.modid, this.event.getExistingFileHelper()){

                    protected void gather() {
                    }
                });
            }
        }
        generator.addProvider(this.event.includeServer(), (DataProvider)new BaseRecipeProvider(generator, this.event.getLookupProvider()){

            protected void buildRecipes(final RecipeOutput consumer) {
                for (Dob dob : DataGen.this.dobs) {
                    dob.recipe().accept(new IRecipeFactory(){

                        @Override
                        public void recipe(Supplier<IRecipeBuilder> supplier) {
                            supplier.get().build(consumer);
                        }

                        @Override
                        public void recipeConsumer(Supplier<Consumer<RecipeOutput>> consumerSupplier) {
                            consumerSupplier.get().accept(consumer);
                        }

                        @Override
                        public void recipe(String id, Supplier<IRecipeBuilder> supplier) {
                            supplier.get().build(consumer, ResourceLocation.fromNamespaceAndPath((String)DataGen.this.modid, (String)id));
                        }

                        @Override
                        public void shapedNBT(CopyComponentsRecipeBuilder builder, String ... pattern) {
                            this.build(consumer, builder, pattern);
                        }

                        @Override
                        public void shapedNBT(String id, CopyComponentsRecipeBuilder builder, String ... pattern) {
                            this.build(consumer, ResourceLocation.fromNamespaceAndPath((String)DataGen.this.modid, (String)id), builder, pattern);
                        }

                        @Override
                        public void shaped(ShapedRecipeBuilder builder, String ... pattern) {
                            this.build(consumer, builder, pattern);
                        }

                        @Override
                        public void shaped(String id, ShapedRecipeBuilder builder, String ... pattern) {
                            this.build(consumer, ResourceLocation.fromNamespaceAndPath((String)DataGen.this.modid, (String)id), builder, pattern);
                        }

                        @Override
                        public void shapeless(ShapelessRecipeBuilder builder) {
                            this.build(consumer, builder);
                        }

                        @Override
                        public void shapeless(String id, ShapelessRecipeBuilder builder) {
                            this.build(consumer, ResourceLocation.fromNamespaceAndPath((String)DataGen.this.modid, (String)id), builder);
                        }
                    });
                }
            }
        });
        BaseLootTableProvider lootTableProvider = new BaseLootTableProvider();
        List<LootTableProvider.SubProviderEntry> list = List.of(new LootTableProvider.SubProviderEntry(provider -> builder -> {
            for (Dob dob : this.dobs) {
                if (dob.blockSupplier() == null) continue;
                dob.loot().accept(lootTableProvider);
            }
            lootTableProvider.generate(builder, LootContextParamSets.BLOCK);
        }, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(provider -> builder -> {
            for (Dob dob : this.dobs) {
                dob.loot().accept(lootTableProvider);
            }
            lootTableProvider.generate(builder, LootContextParamSets.CHEST);
        }, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(provider -> builder -> {
            for (Dob dob : this.dobs) {
                if (dob.entitySupplier() == null) continue;
                dob.loot().accept(lootTableProvider);
            }
            lootTableProvider.generate(builder, LootContextParamSets.ENTITY);
        }, LootContextParamSets.ENTITY));
        generator.addProvider(this.event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Collections.emptySet(), list, this.event.getLookupProvider()));
        BaseBlockTagsProvider blockTags = new BaseBlockTagsProvider(generator, this.event.getLookupProvider(), this.modid, this.event.getExistingFileHelper()){

            @Override
            protected void addTags(HolderLookup.Provider provider) {
                for (Dob dob : DataGen.this.dobs) {
                    dob.blockTags().accept(new ITagFactory(){

                        @Override
                        public void blockTags(Supplier<? extends Block> blockSupplier, List<TagKey> tags) {
                            for (TagKey tag : tags) {
                                this.tag(tag).add((Object)blockSupplier.get());
                            }
                        }

                        @Override
                        public void itemTags(Supplier<? extends Item> itemSupplier, List<TagKey> tags) {
                        }
                    });
                }
            }
        };
        generator.addProvider(this.event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(this.event.includeServer(), (DataProvider)new ItemTagsProvider(generator.getPackOutput(), this.event.getLookupProvider(), blockTags.contentsGetter(), this.modid, this.event.getExistingFileHelper()){

            protected void addTags(HolderLookup.Provider provider) {
                for (Dob dob : DataGen.this.dobs) {
                    dob.itemTags().accept(new ITagFactory(){

                        @Override
                        public void blockTags(Supplier<? extends Block> blockSupplier, List<TagKey> tags) {
                        }

                        @Override
                        public void itemTags(Supplier<? extends Item> itemSupplier, List<TagKey> tags) {
                            for (TagKey tag : tags) {
                                this.tag(tag).add((Object)itemSupplier.get());
                            }
                        }
                    });
                }
            }
        });
        generator.addProvider(this.event.includeClient(), (DataProvider)new LanguageProvider(generator.getPackOutput(), this.modid, "en_us"){

            protected void addTranslations() {
                for (Dob dob : DataGen.this.dobs) {
                    String name = dob.translatedName();
                    if (name != null) {
                        if (dob.blockSupplier() != null) {
                            this.add(dob.blockSupplier().get(), name);
                        } else if (dob.itemSupplier() != null) {
                            this.add(dob.itemSupplier().get(), name);
                        } else if (dob.entitySupplier() != null) {
                            this.add(dob.entitySupplier().get(), name);
                        }
                    }
                    Map<String, String> keyedMessages = dob.keyedMessages();
                    for (Map.Entry<String, String> entry : keyedMessages.entrySet()) {
                        String key;
                        if (dob.blockSupplier() != null) {
                            key = Util.makeDescriptionId((String)"message", (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)dob.blockSupplier().get()));
                        } else if (dob.itemSupplier() != null) {
                            key = Util.makeDescriptionId((String)"message", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)dob.itemSupplier().get()));
                        } else if (dob.entitySupplier() != null) {
                            key = Util.makeDescriptionId((String)"message", (ResourceLocation)BuiltInRegistries.ENTITY_TYPE.getKey((Object)dob.entitySupplier().get()));
                        } else {
                            throw new RuntimeException("Not supported!");
                        }
                        this.add(key + "." + entry.getKey(), entry.getValue());
                    }
                    Map<String, String> messages = dob.messages();
                    for (Map.Entry<String, String> entry : messages.entrySet()) {
                        this.add(entry.getKey(), entry.getValue());
                    }
                }
            }
        });
        generator.addProvider(this.event.includeClient(), (DataProvider)new BaseBlockStateProvider(generator, this.modid, this.event.getExistingFileHelper()){

            protected void registerStatesAndModels() {
                for (Dob dob : DataGen.this.dobs) {
                    dob.blockstate().accept(this);
                }
            }
        });
        generator.addProvider(this.event.includeClient(), (DataProvider)new BaseItemModelProvider(generator, this.modid, this.event.getExistingFileHelper()){

            protected void registerModels() {
                8 provider = this;
                for (Dob dob : DataGen.this.dobs) {
                    dob.item().accept(provider);
                }
            }
        });
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item});
    }

    public static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> tag) {
        return DataGen.inventoryTrigger(ItemPredicate.Builder.item().of(tag).build());
    }

    public static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... itemPredicate) {
        return new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(itemPredicate));
    }

    record CodecProvider(String directory, Codec codec) {
    }
}

