/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntitySiren;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class SirenIslandStructure
extends Structure {
    public static final MapCodec<SirenIslandStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SirenIslandStructure.settingsCodec((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, SirenIslandStructure::new));

    protected SirenIslandStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (context.random().nextDouble() >= (Double)IafCommonConfig.INSTANCE.worldGen.generateSirenIslandChance.getValue()) {
            return Optional.empty();
        }
        Rotation blockRotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos blockPos = this.getLowestYIn5by5BoxOffset7Blocks(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.addPiece((StructurePiece)new SirenIslandPiece(0, new BoundingBox(blockPos.getX(), blockPos.getY(), blockPos.getZ(), blockPos.getX(), blockPos.getY(), blockPos.getZ())))));
    }

    public StructureType<?> type() {
        return (StructureType)IafStructureTypes.SIREN_ISLAND.get();
    }

    public static class SirenIslandPiece
    extends StructurePiece {
        protected SirenIslandPiece(int length, BoundingBox boundingBox) {
            super((StructurePieceType)IafStructurePieces.SIREN_ISLAND.get(), length, boundingBox);
        }

        public SirenIslandPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.SIREN_ISLAND.get(), nbt);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            BlockPos stonePos;
            float j;
            float i;
            int up = random.nextInt(4) + 1;
            BlockPos center = pivot.above(up);
            int layer = 0;
            int sirens = 1 + random.nextInt(3);
            while (!world.getBlockState(center).canOcclude() && center.getY() >= world.getMinBuildHeight()) {
                ++layer;
                for (i = 0.0f; i < (float)this.getRadius(layer, up); i += 0.5f) {
                    j = 0.0f;
                    while ((double)j < Math.PI * 2 * (double)i + (double)random.nextInt(2)) {
                        stonePos = BlockPos.containing((double)Math.floor((float)center.getX() + Mth.sin((float)j) * i + (float)random.nextInt(2)), (double)center.getY(), (double)Math.floor((float)center.getZ() + Mth.cos((float)j) * i + (float)random.nextInt(2)));
                        world.setBlock(stonePos, this.getStone(random), 3);
                        BlockPos upPos = stonePos.above();
                        if (world.isEmptyBlock(upPos) && world.isEmptyBlock(upPos.east()) && world.isEmptyBlock(upPos.north()) && world.isEmptyBlock(upPos.north().east()) && random.nextInt(3) == 0 && sirens > 0) {
                            this.spawnSiren((ServerLevelAccessor)world, random, upPos.north().east());
                            --sirens;
                        }
                        j += 0.5f;
                    }
                }
                center = center.below();
            }
            ++layer;
            for (i = 0.0f; i < (float)this.getRadius(layer, up); i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i + (double)random.nextInt(2)) {
                    stonePos = BlockPos.containing((double)Math.floor((float)center.getX() + Mth.sin((float)j) * i + (float)random.nextInt(2)), (double)center.getY(), (double)Math.floor((float)center.getZ() + Mth.cos((float)j) * i + (float)random.nextInt(2)));
                    while (!world.getBlockState(stonePos).canOcclude() && stonePos.getY() >= 0) {
                        world.setBlock(stonePos, this.getStone(random), 3);
                        stonePos = stonePos.below();
                    }
                    j += 0.5f;
                }
            }
        }

        private int getRadius(int layer, int up) {
            int MAX_ISLAND_RADIUS = 10;
            return layer > up ? (int)((double)layer * 0.25) + up : Math.min(layer, MAX_ISLAND_RADIUS);
        }

        private BlockState getStone(RandomSource random) {
            int chance = random.nextInt(100);
            if (chance > 90) {
                return Blocks.MOSSY_COBBLESTONE.defaultBlockState();
            }
            if (chance > 70) {
                return Blocks.GRAVEL.defaultBlockState();
            }
            if (chance > 45) {
                return Blocks.COBBLESTONE.defaultBlockState();
            }
            return Blocks.STONE.defaultBlockState();
        }

        private void spawnSiren(ServerLevelAccessor worldIn, RandomSource rand, BlockPos position) {
            EntitySiren siren = new EntitySiren((EntityType<EntitySiren>)((EntityType)IafEntities.SIREN.get()), (Level)worldIn.getLevel());
            siren.setSinging(true);
            siren.setHairColor(rand.nextInt(2));
            siren.setSingingPose(rand.nextInt(2));
            siren.absMoveTo((double)position.getX() + 0.5, position.getY() + 1, (double)position.getZ() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
            worldIn.addFreshEntity((Entity)siren);
        }
    }
}

