/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.LootTable;

public class HydraCaveStructure
extends Structure {
    public static final MapCodec<HydraCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HydraCaveStructure.settingsCodec((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, HydraCaveStructure::new));

    protected HydraCaveStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (context.random().nextDouble() >= (Double)IafCommonConfig.INSTANCE.worldGen.generateHydraCaveChance.getValue()) {
            return Optional.empty();
        }
        Rotation blockRotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos blockPos = this.getLowestYIn5by5BoxOffset7Blocks(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.addPiece((StructurePiece)new HydraCavePiece(0, new BoundingBox(blockPos.getX(), blockPos.getY(), blockPos.getZ(), blockPos.getX(), blockPos.getY(), blockPos.getZ())))));
    }

    public StructureType<?> type() {
        return (StructureType)IafStructureTypes.HYDRA_CAVE.get();
    }

    public static class HydraCavePiece
    extends StructurePiece {
        public static final ResourceKey<LootTable> HYDRA_CHEST = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"chest/hydra_cave"));

        protected HydraCavePiece(int length, BoundingBox boundingBox) {
            super((StructurePieceType)IafStructurePieces.HYDRA_CAVE.get(), length, boundingBox);
        }

        public HydraCavePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.HYDRA_CAVE.get(), nbt);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            int i1 = 8;
            int i2 = i1 - 2;
            int ySize = random.nextInt(2);
            int j = i1 + random.nextInt(2);
            int k = 5 + ySize;
            int l = i1 + random.nextInt(2);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.betweenClosedStream((BlockPos)pivot.offset(-j, -k, -l), (BlockPos)pivot.offset(j, k, l)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                boolean isNotInDoorway;
                boolean doorwayX = blockpos.getX() >= pivot.getX() - 2 + random.nextInt(2) && blockpos.getX() <= pivot.getX() + 2 + random.nextInt(2);
                boolean doorwayZ = blockpos.getZ() >= pivot.getZ() - 2 + random.nextInt(2) && blockpos.getZ() <= pivot.getZ() + 2 + random.nextInt(2);
                boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.getY() > pivot.getY() || blockpos.getY() > pivot.getY() + k - (1 + random.nextInt(2));
                if (!(blockpos.distSqr((Vec3i)pivot) <= (double)(f * f))) continue;
                if (!(world.getBlockState(pivot).getBlock() instanceof ChestBlock) && isNotInDoorway) {
                    world.setBlock(blockpos, Blocks.GRASS_BLOCK.defaultBlockState(), 3);
                    if (world.getBlockState(pivot.below()).getBlock() == Blocks.GRASS_BLOCK) {
                        world.setBlock(blockpos.below(), Blocks.DIRT.defaultBlockState(), 3);
                    }
                    if (random.nextInt(4) == 0) {
                        world.setBlock(blockpos.above(), Blocks.SHORT_GRASS.defaultBlockState(), 2);
                    }
                    if (random.nextInt(9) == 0) {
                        world.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(TreeFeatures.SWAMP_OAK).ifPresent(holder -> ((ConfiguredFeature)holder.value()).place(world, chunkGenerator, random, blockpos.above()));
                    }
                }
                if (blockpos.getY() == pivot.getY()) {
                    world.setBlock(blockpos, Blocks.GRASS_BLOCK.defaultBlockState(), 3);
                }
                if (blockpos.getY() > pivot.getY() - 1 || world.getBlockState(blockpos).canOcclude()) continue;
                world.setBlock(blockpos, Blocks.STONE.defaultBlockState(), 3);
            }
            ySize = random.nextInt(2);
            j = i2 + random.nextInt(2);
            k = 4 + ySize;
            l = i2 + random.nextInt(2);
            f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.betweenClosedStream((BlockPos)pivot.offset(-j, -k, -l), (BlockPos)pivot.offset(j, k, l)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                if (!(blockpos.distSqr((Vec3i)pivot) <= (double)(f * f)) || blockpos.getY() <= pivot.getY() || world.getBlockState(pivot).getBlock() instanceof ChestBlock) continue;
                world.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 3);
            }
            for (BlockPos blockpos : BlockPos.betweenClosedStream((BlockPos)pivot.offset(-j, -k, -l), (BlockPos)pivot.offset(j, k + 8, l)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                if (!(blockpos.distSqr((Vec3i)pivot) <= (double)(f * f)) || blockpos.getY() != pivot.getY()) continue;
                if (random.nextInt(30) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.above())) {
                    BlockEntity blockEntity;
                    world.setBlock(blockpos.above(1), (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)GenerationConstants.HORIZONTALS[new Random().nextInt(3)]), 2);
                    if (!(world.getBlockState(blockpos.above(1)).getBlock() instanceof ChestBlock) || !((blockEntity = world.getBlockEntity(blockpos.above(1))) instanceof ChestBlockEntity)) continue;
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    chest.setLootTable(HYDRA_CHEST, random.nextLong());
                    continue;
                }
                if (random.nextInt(45) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.above())) {
                    world.setBlock(blockpos.above(), (BlockState)Blocks.SKELETON_SKULL.defaultBlockState().setValue((Property)SkullBlock.ROTATION, (Comparable)Integer.valueOf(random.nextInt(15))), 2);
                    continue;
                }
                if (random.nextInt(35) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.above())) {
                    world.setBlock(blockpos.above(), (BlockState)Blocks.OAK_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
                    for (Direction facing : Direction.values()) {
                        if (!(random.nextFloat() < 0.3f) || facing == Direction.DOWN) continue;
                        world.setBlock(blockpos.above().relative(facing), Blocks.OAK_LEAVES.defaultBlockState(), 2);
                    }
                    continue;
                }
                if (random.nextInt(15) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.above())) {
                    world.setBlock(blockpos.above(), Blocks.TALL_GRASS.defaultBlockState(), 2);
                    continue;
                }
                if (random.nextInt(15) != 0 || !this.isTouchingAir((LevelAccessor)world, blockpos.above())) continue;
                world.setBlock(blockpos.above(), random.nextBoolean() ? Blocks.BROWN_MUSHROOM.defaultBlockState() : Blocks.RED_MUSHROOM.defaultBlockState(), 2);
            }
            EntityHydra hydra = new EntityHydra((EntityType<EntityHydra>)((EntityType)IafEntities.HYDRA.get()), (Level)world.getLevel());
            hydra.setVariant(random.nextInt(3));
            hydra.restrictTo(pivot, 15);
            hydra.absMoveTo((double)pivot.getX() + 0.5, (double)pivot.getY() + 1.5, (double)pivot.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            world.addFreshEntity((Entity)hydra);
        }

        private boolean isTouchingAir(LevelAccessor worldIn, BlockPos pos) {
            for (Direction direction : GenerationConstants.HORIZONTALS) {
                if (worldIn.isEmptyBlock(pos.relative(direction))) continue;
                return false;
            }
            return true;
        }
    }
}

