/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.processor;

import com.iafenvoy.iceandfire.item.block.BlockDreadBase;
import com.iafenvoy.iceandfire.item.block.util.IDreadBlock;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafProcessors;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DreadRuinProcessor
extends StructureProcessor {
    public static final DreadRuinProcessor INSTANCE = new DreadRuinProcessor();
    public static final MapCodec<DreadRuinProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public static BlockState getRandomCrackedBlock(BlockState prev, RandomSource random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.5) {
            return (BlockState)((BlockDreadBase)IafBlocks.DREAD_STONE_BRICKS.get()).defaultBlockState().setValue((Property)IDreadBlock.UNBREAKABLE, (Comparable)Boolean.valueOf(true));
        }
        if ((double)rand < 0.9) {
            return (BlockState)((BlockDreadBase)IafBlocks.DREAD_STONE_BRICKS_CRACKED.get()).defaultBlockState().setValue((Property)IDreadBlock.UNBREAKABLE, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockDreadBase)IafBlocks.DREAD_STONE_BRICKS_MOSSY.get()).defaultBlockState().setValue((Property)IDreadBlock.UNBREAKABLE, (Comparable)Boolean.valueOf(true));
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        RandomSource random = settings.getRandom(infoIn2.pos());
        if (infoIn2.state().getBlock() == IafBlocks.DREAD_STONE_BRICKS.get()) {
            BlockState state = DreadRuinProcessor.getRandomCrackedBlock(null, random);
            return new StructureTemplate.StructureBlockInfo(infoIn2.pos(), state, null);
        }
        if (infoIn2.state().getBlock() == IafBlocks.DREAD_SPAWNER.get()) {
            CompoundTag tag = new CompoundTag();
            CompoundTag spawnData = new CompoundTag();
            ResourceLocation spawnerMobId = BuiltInRegistries.ENTITY_TYPE.getKey(this.getRandomMobForMobSpawner(random));
            CompoundTag entity = new CompoundTag();
            entity.putString("id", spawnerMobId.toString());
            spawnData.put("entity", (Tag)entity);
            tag.remove("SpawnPotentials");
            tag.put("SpawnData", (Tag)spawnData.copy());
            return new StructureTemplate.StructureBlockInfo(infoIn2.pos(), ((Block)IafBlocks.DREAD_SPAWNER.get()).defaultBlockState(), tag);
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)IafProcessors.DREAD_MAUSOLEUM_PROCESSOR.get();
    }

    private EntityType<?> getRandomMobForMobSpawner(RandomSource random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.3) {
            return (EntityType)IafEntities.DREAD_THRALL.get();
        }
        if ((double)rand < 0.5) {
            return (EntityType)IafEntities.DREAD_GHOUL.get();
        }
        if ((double)rand < 0.7) {
            return (EntityType)IafEntities.DREAD_BEAST.get();
        }
        if ((double)rand < 0.85) {
            return (EntityType)IafEntities.DREAD_SCUTTLER.get();
        }
        return (EntityType)IafEntities.DREAD_KNIGHT.get();
    }
}

