/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpent;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;

public class SpawnSeaSerpent
extends Feature<NoneFeatureConfiguration> {
    public SpawnSeaSerpent(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        WorldGenLevel worldIn = context.level();
        RandomSource rand = context.random();
        BlockPos position = context.origin();
        position = worldIn.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, position.offset(8, 0, 8));
        BlockPos oceanPos = worldIn.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR_WG, position.offset(8, 0, 8));
        if (GenerationConstants.isFarEnoughFromSpawn(position) && rand.nextDouble() < (Double)IafCommonConfig.INSTANCE.seaSerpent.spawnChance.getValue() && worldIn.getFluidState(pos = oceanPos.offset(rand.nextInt(10) - 5, rand.nextInt(30), rand.nextInt(10) - 5)).getType() == Fluids.WATER) {
            EntitySeaSerpent serpent = (EntitySeaSerpent)((EntityType)IafEntities.SEA_SERPENT.get()).create((Level)worldIn.getLevel());
            assert (serpent != null);
            serpent.onWorldSpawn(rand);
            serpent.moveTo((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f, 0.0f, 0.0f);
            worldIn.addFreshEntity((Entity)serpent);
        }
        return true;
    }
}

