/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model.animator;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.render.model.animator.IceAndFireTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.IceDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.util.EnumDragonPoses;
import com.iafenvoy.iceandfire.render.model.util.LegArticulator;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public abstract class DragonTabulaModelAnimator
extends IceAndFireTabulaModelAnimator<EntityDragonBase>
implements ITabulaModelAnimator<EntityDragonBase> {
    private final Map<EnumDragonPoses, TabulaModel<EntityDragonBase>> CACHES = new LinkedHashMap<EnumDragonPoses, TabulaModel<EntityDragonBase>>();
    protected TabulaModel<EntityDragonBase>[] walkPoses;
    protected TabulaModel<EntityDragonBase>[] flyPoses;
    protected TabulaModel<EntityDragonBase>[] swimPoses;
    protected AdvancedModelBox[] neckParts;
    protected AdvancedModelBox[] tailParts;
    protected AdvancedModelBox[] tailPartsWBody;
    protected AdvancedModelBox[] toesPartsL;
    protected AdvancedModelBox[] toesPartsR;
    protected AdvancedModelBox[] clawL;
    protected AdvancedModelBox[] clawR;

    public DragonTabulaModelAnimator(TabulaModel<EntityDragonBase> baseModel) {
        super(baseModel);
    }

    public void init(TabulaModel<EntityDragonBase> model) {
        this.neckParts = new AdvancedModelBox[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Head")};
        this.tailParts = new AdvancedModelBox[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.tailPartsWBody = new AdvancedModelBox[]{model.getCube("BodyLower"), model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.toesPartsL = new AdvancedModelBox[]{model.getCube("ToeL1"), model.getCube("ToeL2"), model.getCube("ToeL3")};
        this.toesPartsR = new AdvancedModelBox[]{model.getCube("ToeR1"), model.getCube("ToeR2"), model.getCube("ToeR3")};
        this.clawL = new AdvancedModelBox[]{model.getCube("ClawL")};
        this.clawR = new AdvancedModelBox[]{model.getCube("ClawR")};
    }

    public void setRotationAngles(TabulaModel<EntityDragonBase> model, EntityDragonBase entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        TabulaModel<EntityDragonBase> currentPosition;
        int prevIndex;
        int currentIndex;
        model.resetToDefaultPose();
        if (this.neckParts == null) {
            this.init(model);
        }
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        boolean walking = !entity.isHovering() && !entity.isFlying() && entity.hoverProgress <= 0.0f && entity.flyProgress <= 0.0f;
        boolean swimming = entity.isInWater() && entity.swimProgress > 0.0f;
        int n = currentIndex = walking ? entity.walkCycle / 10 : entity.flightCycle / 10;
        if (swimming) {
            currentIndex = entity.swimCycle / 10;
        }
        if ((prevIndex = currentIndex - 1) < 0) {
            int n2 = swimming ? 4 : (prevIndex = walking ? 3 : 5);
        }
        TabulaModel<EntityDragonBase> tabulaModel = swimming ? this.swimPoses[currentIndex] : (currentPosition = walking ? this.walkPoses[currentIndex] : this.flyPoses[currentIndex]);
        TabulaModel<EntityDragonBase> prevPosition = swimming ? this.swimPoses[prevIndex] : (walking ? this.walkPoses[prevIndex] : this.flyPoses[prevIndex]);
        float delta = (float)(walking ? entity.walkCycle : entity.flightCycle) / 10.0f % 1.0f;
        if (swimming) {
            delta = (float)entity.swimCycle / 10.0f % 1.0f;
        }
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        float deltaTicks = delta + partialTick / 10.0f;
        if (delta == 0.0f) {
            deltaTicks = 0.0f;
        }
        float speed_walk = 0.2f;
        float speed_idle = entity.isSleeping() ? 0.025f : 0.05f;
        float speed_fly = 0.2f;
        float degree_walk = 0.5f;
        float degree_idle = entity.isSleeping() ? 0.25f : 0.5f;
        float degree_fly = 0.5f;
        if (entity.isModelDead()) {
            for (AdvancedModelBox cube : model.getCubes().values()) {
                this.setRotationsLoopDeath(model, entity, limbSwingAmount, walking, currentPosition, prevPosition, partialTick, deltaTicks, cube);
            }
            return;
        }
        if (entity.isNoAi()) {
            return;
        }
        for (AdvancedModelBox cube : model.getCubes().values()) {
            this.setRotationsLoop(model, entity, limbSwingAmount, walking, currentPosition, prevPosition, partialTick, deltaTicks, cube);
        }
        if (entity.getAnimation() != EntityDragonBase.ANIMATION_SHAKEPREY || entity.getAnimation() != EntityDragonBase.ANIMATION_ROAR) {
            model.faceTarget(rotationYaw, rotationPitch, 2.0f, this.neckParts);
        }
        if (!walking) {
            model.bob(model.getCube("BodyUpper"), -speed_fly, degree_fly * 5.0f, false, ageInTicks, 1.0f);
            model.walk(model.getCube("BodyUpper"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            model.chainWave(this.tailPartsWBody, speed_fly, degree_fly * -0.1f, 0.0, ageInTicks, 1.0f);
            model.chainWave(this.neckParts, speed_fly, degree_fly * 0.2f, -4.0, ageInTicks, 1.0f);
            model.chainWave(this.toesPartsL, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
            model.chainWave(this.toesPartsR, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
            model.walk(model.getCube("ThighR"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            model.walk(model.getCube("ThighL"), -speed_fly, degree_fly * 0.1f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
        } else {
            model.bob(model.getCube("BodyUpper"), speed_walk * 2.0f, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
            model.bob(model.getCube("ThighR"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
            model.bob(model.getCube("ThighL"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
            model.chainSwing(this.tailParts, speed_walk, degree_walk * 0.25f, -2.0, limbSwing, limbSwingAmount);
            model.chainWave(this.tailParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
            model.chainSwing(this.neckParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
            model.chainWave(this.neckParts, speed_walk, degree_walk * 0.05f, -2.0, limbSwing, limbSwingAmount);
            model.chainSwing(this.tailParts, speed_idle, degree_idle * 0.25f, -2.0, ageInTicks, 1.0f);
            model.chainWave(this.tailParts, speed_idle, degree_idle * 0.15f, -2.0, ageInTicks, 1.0f);
            model.chainWave(this.neckParts, speed_idle, degree_idle * -0.15f, -3.0, ageInTicks, 1.0f);
            model.walk(model.getCube("Neck1"), speed_idle, degree_idle * 0.05f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
        }
        model.bob(model.getCube("BodyUpper"), speed_idle, degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("ThighR"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("ThighL"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("armR1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("armL1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        if (entity.isActuallyBreathingFire()) {
            float speed_shake = 0.7f;
            float degree_shake = 0.1f;
            model.chainFlap(this.neckParts, speed_shake, degree_shake, 2.0, ageInTicks, 1.0f);
            model.chainSwing(this.neckParts, speed_shake * 0.65f, degree_shake * 0.1f, 1.0, ageInTicks, 1.0f);
        }
        if (entity.turn_buffer != null && !entity.isVehicle() && !entity.isPassenger() && entity.isBreathingFire()) {
            entity.turn_buffer.applyChainSwingBuffer((BasicModelPart[])this.neckParts);
        }
        if (entity.tail_buffer != null && !entity.isPassenger()) {
            entity.tail_buffer.applyChainSwingBuffer((BasicModelPart[])this.tailPartsWBody);
        }
        if (entity.roll_buffer != null && entity.pitch_buffer_body != null && entity.pitch_buffer != null && (entity.flyProgress > 0.0f || entity.hoverProgress > 0.0f)) {
            entity.roll_buffer.applyChainFlapBuffer(new BasicModelPart[]{model.getCube("BodyUpper")});
            entity.pitch_buffer_body.applyChainWaveBuffer(new BasicModelPart[]{model.getCube("BodyUpper")});
            entity.pitch_buffer.applyChainWaveBufferReverse((BasicModelPart[])this.tailPartsWBody);
        }
        if (entity.getBbWidth() >= 2.0f && entity.flyProgress == 0.0f && entity.hoverProgress == 0.0f) {
            LegArticulator.articulateQuadruped(entity, entity.legSolver, model.getCube("BodyUpper"), model.getCube("BodyLower"), model.getCube("Neck1"), model.getCube("ThighL"), model.getCube("LegL"), this.toesPartsL, model.getCube("ThighR"), model.getCube("LegR"), this.toesPartsR, model.getCube("armL1"), model.getCube("armL2"), this.clawL, model.getCube("armR1"), model.getCube("armR2"), this.clawR, 1.0f, 0.5f, 0.5f, -0.15f, -0.15f, 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }
    }

    private void setRotationsLoop(TabulaModel<EntityDragonBase> model, EntityDragonBase entity, float limbSwingAmount, boolean walking, TabulaModel<EntityDragonBase> currentPosition, TabulaModel<EntityDragonBase> prevPosition, float partialTick, float deltaTicks, AdvancedModelBox cube) {
        float z;
        float y;
        float x;
        float prevZ;
        float prevY;
        float prevX;
        AdvancedModelBox currPositionCube;
        AdvancedModelBox prevPositionCube;
        this.genderMob(entity, cube);
        if (walking && entity.flyProgress <= 0.0f && entity.hoverProgress <= 0.0f && entity.modelDeadProgress <= 0.0f) {
            AdvancedModelBox walkPart = this.getModel(EnumDragonPoses.GROUND_POSE).getCube(cube.boxName);
            prevPositionCube = prevPosition.getCube(cube.boxName);
            currPositionCube = currentPosition.getCube(cube.boxName);
            if (prevPositionCube == null || currPositionCube == null) {
                return;
            }
            prevX = prevPositionCube.rotateAngleX;
            prevY = prevPositionCube.rotateAngleY;
            prevZ = prevPositionCube.rotateAngleZ;
            x = currPositionCube.rotateAngleX;
            y = currPositionCube.rotateAngleY;
            z = currPositionCube.rotateAngleZ;
            if (this.isHorn(cube) || this.isWing(model, cube) && (entity.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST || entity.getAnimation() == EntityDragonBase.ANIMATION_EPIC_ROAR)) {
                this.addToRotateAngle(cube, limbSwingAmount, walkPart.rotateAngleX, walkPart.rotateAngleY, walkPart.rotateAngleZ);
            } else {
                this.addToRotateAngle(cube, limbSwingAmount, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
            }
        }
        if (entity.sleepProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.SLEEPING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.SLEEPING_POSE).getCube(cube.boxName), Mth.lerp((float)partialTick, (float)entity.prevAnimationProgresses[1], (float)entity.sleepProgress), 20.0f, false);
        }
        if (entity.hoverProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.HOVERING_POSE).getCube(cube.boxName)) && !this.isWing(model, cube) && !cube.boxName.contains("Tail")) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.HOVERING_POSE).getCube(cube.boxName), Mth.lerp((float)partialTick, (float)entity.prevAnimationProgresses[2], (float)entity.hoverProgress), 20.0f, false);
        }
        if (entity.flyProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName), Mth.lerp((float)partialTick, (float)entity.prevAnimationProgresses[3], (float)entity.flyProgress) - Mth.lerp((float)partialTick, (float)entity.prevDiveProgress, (float)entity.diveProgress) * 2.0f, 20.0f, false);
        }
        if (entity.sitProgress > 0.0f && !entity.isPassenger() && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.SITTING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.SITTING_POSE).getCube(cube.boxName), Mth.lerp((float)partialTick, (float)entity.prevAnimationProgresses[0], (float)entity.sitProgress), 20.0f, false);
        }
        if (entity.ridingProgress > 0.0f && !this.isHorn(cube) && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.SIT_ON_PLAYER_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.SIT_ON_PLAYER_POSE).getCube(cube.boxName), Mth.lerp((float)partialTick, (float)entity.prevAnimationProgresses[5], (float)entity.ridingProgress), 20.0f, false);
            if (cube.boxName.equals("BodyUpper")) {
                cube.offsetZ += (-12.0f - cube.offsetZ) / 20.0f * Mth.lerp((float)partialTick, (float)entity.prevAnimationProgresses[5], (float)entity.ridingProgress);
            }
        }
        if (entity.tackleProgress > 0.0f && !this.isRotationEqual(this.getModel(EnumDragonPoses.TACKLE).getCube(cube.boxName), this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName)) && !this.isWing(model, cube)) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.TACKLE).getCube(cube.boxName), Mth.lerp((float)partialTick, (float)entity.prevAnimationProgresses[6], (float)entity.tackleProgress), 5.0f, false);
        }
        if (entity.diveProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.DIVING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.DIVING_POSE).getCube(cube.boxName), Mth.lerp((float)partialTick, (float)entity.prevDiveProgress, (float)entity.diveProgress), 10.0f, false);
        }
        if (entity.fireBreathProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.STREAM_BREATH).getCube(cube.boxName)) && !this.isWing(model, cube) && !cube.boxName.contains("Finger")) {
            if (entity.prevFireBreathProgress <= entity.fireBreathProgress) {
                this.transitionTo(cube, this.getModel(EnumDragonPoses.BLAST_CHARGE3).getCube(cube.boxName), Mth.clamp((float)Mth.lerp((float)partialTick, (float)entity.prevFireBreathProgress, (float)entity.fireBreathProgress), (float)0.0f, (float)5.0f), 5.0f, false);
            }
            this.transitionTo(cube, this.getModel(EnumDragonPoses.STREAM_BREATH).getCube(cube.boxName), Mth.clamp((float)(Mth.lerp((float)partialTick, (float)entity.prevFireBreathProgress, (float)entity.fireBreathProgress) - 5.0f), (float)0.0f, (float)5.0f), 5.0f, false);
        }
        if (!walking) {
            AdvancedModelBox flightPart = this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName);
            prevPositionCube = prevPosition.getCube(cube.boxName);
            currPositionCube = currentPosition.getCube(cube.boxName);
            prevX = prevPositionCube.rotateAngleX;
            prevY = prevPositionCube.rotateAngleY;
            prevZ = prevPositionCube.rotateAngleZ;
            x = currPositionCube.rotateAngleX;
            y = currPositionCube.rotateAngleY;
            z = currPositionCube.rotateAngleZ;
            if (x != flightPart.rotateAngleX || y != flightPart.rotateAngleY || z != flightPart.rotateAngleZ) {
                this.setRotateAngle(cube, 1.0f, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
            }
        }
    }

    public void setRotationsLoopDeath(TabulaModel<EntityDragonBase> model, EntityDragonBase entity, float limbSwingAmount, boolean walking, TabulaModel<EntityDragonBase> currentPosition, TabulaModel<EntityDragonBase> prevPosition, float partialTick, float deltaTicks, AdvancedModelBox cube) {
        if (entity.modelDeadProgress > 0.0f) {
            TabulaModel<EntityDragonBase> pose = this.getModel(EnumDragonPoses.DEAD);
            if (!this.isRotationEqual(cube, pose.getCube(cube.boxName))) {
                this.transitionTo(cube, pose.getCube(cube.boxName), entity.prevModelDeadProgress + (entity.modelDeadProgress - entity.prevModelDeadProgress) * Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), 20.0f, cube.boxName.equals("ThighR") || cube.boxName.equals("ThighL"));
            }
            if (this instanceof IceDragonTabulaModelAnimator && cube.boxName.equals("BodyUpper")) {
                cube.rotationPointY += 0.35f * Mth.lerp((float)partialTick, (float)entity.prevModelDeadProgress, (float)entity.modelDeadProgress);
            }
        }
    }

    protected boolean isWing(TabulaModel<EntityDragonBase> model, AdvancedModelBox modelRenderer) {
        return model.getCube("armL1") == modelRenderer || model.getCube("armR1") == modelRenderer || model.getCube((String)"armL1").childModels.contains((Object)modelRenderer) || model.getCube((String)"armR1").childModels.contains((Object)modelRenderer);
    }

    protected boolean isHorn(AdvancedModelBox modelRenderer) {
        return modelRenderer.boxName.contains("Horn");
    }

    protected void genderMob(EntityDragonBase entity, AdvancedModelBox cube) {
        if (!entity.isMale()) {
            TabulaModel<EntityDragonBase> maleModel = this.getModel(EnumDragonPoses.MALE);
            TabulaModel<EntityDragonBase> femaleModel = this.getModel(EnumDragonPoses.FEMALE);
            AdvancedModelBox femaleModelCube = femaleModel.getCube(cube.boxName);
            AdvancedModelBox maleModelCube = maleModel.getCube(cube.boxName);
            if (maleModelCube == null || femaleModelCube == null) {
                return;
            }
            float x = femaleModelCube.rotateAngleX;
            float y = femaleModelCube.rotateAngleY;
            float z = femaleModelCube.rotateAngleZ;
            if (x != maleModelCube.rotateAngleX || y != maleModelCube.rotateAngleY || z != maleModelCube.rotateAngleZ) {
                this.setRotateAngle(cube, 1.0f, x, y, z);
            }
        }
    }

    protected TabulaModel<EntityDragonBase> getModel(EnumDragonPoses pose) {
        if (this.CACHES.containsKey(pose)) {
            return this.CACHES.get(pose);
        }
        TabulaModel<EntityDragonBase> model = this.getModelInternal(pose);
        this.CACHES.put(pose, model);
        return model;
    }

    protected abstract TabulaModel<EntityDragonBase> getModelInternal(EnumDragonPoses var1);

    protected void animate(TabulaModel<EntityDragonBase> model, EntityDragonBase entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox modelCubeJaw = model.getCube("Jaw");
        AdvancedModelBox modelCubeBodyUpper = model.getCube("BodyUpper");
        model.animator.update((IAnimatedEntity)entity);
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_FIRECHARGE)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.BLAST_CHARGE1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.BLAST_CHARGE2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.BLAST_CHARGE3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(5);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_SPEAK)) {
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.setStaticKeyframe(5);
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.resetKeyframe(5);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_BITE)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.BITE1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.BITE2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.BITE3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_SHAKEPREY)) {
            model.animator.startKeyframe(15);
            this.moveToPose(model, this.getModel(EnumDragonPoses.GRAB1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.GRAB2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.GRAB_SHAKE1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.GRAB_SHAKE2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.GRAB_SHAKE3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_TAILWHACK)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.TAIL_WHIP1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.TAIL_WHIP2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.TAIL_WHIP3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_WINGBLAST)) {
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.WING_BLAST1));
            model.animator.move(modelCubeBodyUpper, 0.0f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.WING_BLAST2));
            model.animator.move(modelCubeBodyUpper, 0.0f, -2.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.WING_BLAST3));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.WING_BLAST4));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.WING_BLAST5));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.WING_BLAST6));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(EnumDragonPoses.WING_BLAST7));
            model.animator.move(modelCubeBodyUpper, 0.0f, -2.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_ROAR)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.ROAR1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.ROAR2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.ROAR3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_EPIC_ROAR)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.EPIC_ROAR1));
            model.animator.rotate(modelCubeBodyUpper, -0.1f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.EPIC_ROAR2));
            model.animator.rotate(modelCubeBodyUpper, -0.2f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.EPIC_ROAR3));
            model.animator.rotate(modelCubeBodyUpper, -0.2f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.EPIC_ROAR2));
            model.animator.rotate(modelCubeBodyUpper, -0.2f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(EnumDragonPoses.EPIC_ROAR3));
            model.animator.rotate(modelCubeBodyUpper, -0.1f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(EntityDragonBase.ANIMATION_EAT)) {
            model.animator.startKeyframe(5);
            this.rotate(model.animator, model.getCube("Neck1"), 18.0f, 0.0f, 0.0f);
            this.rotate(model.animator, model.getCube("Neck2"), 18.0f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.setStaticKeyframe(5);
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.rotate(model.animator, model.getCube("Neck1"), -18.0f, 0.0f, 0.0f);
            this.rotate(model.animator, model.getCube("Neck2"), -18.0f, 0.0f, 0.0f);
            model.animator.endKeyframe();
        }
    }
}

