/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model;

import com.iafenvoy.iceandfire.entity.EntityDreadKnight;
import com.iafenvoy.iceandfire.render.model.ModelDreadBase;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ModelAnimator;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.util.HideableModelRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ModelDreadKnight
extends ModelDreadBase<EntityDreadKnight> {
    public final HideableModelRenderer chestplate;
    public final HideableModelRenderer cloak;
    public final HideableModelRenderer crown;
    public final HideableModelRenderer sleeveRight;
    public final HideableModelRenderer robeLowerRight;
    public final HideableModelRenderer sleeveLeft;
    public final HideableModelRenderer robeLowerLeft;

    public ModelDreadKnight(float modelScale) {
        this.texWidth = 128;
        this.texHeight = 64;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.sleeveRight = new HideableModelRenderer((AdvancedEntityModel)this, 35, 33);
        this.sleeveRight.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveRight.addBox(-4.0f, -2.1f, -2.5f, 5.0f, 6.0f, 5.0f, modelScale);
        this.chestplate = new HideableModelRenderer((AdvancedEntityModel)this, 1, 32);
        this.chestplate.setPos(0.0f, 0.1f, 0.0f);
        this.chestplate.addBox(-4.5f, 0.0f, -2.5f, 9.0f, 11.0f, 5.0f, modelScale);
        this.crown = new HideableModelRenderer((AdvancedEntityModel)this, 58, -1);
        this.crown.setPos(0.0f, 0.0f, 0.0f);
        this.crown.addBox(-4.5f, -10.2f, -4.5f, 9.0f, 11.0f, 9.0f, modelScale);
        this.body = new HideableModelRenderer((AdvancedEntityModel)this, 16, 16);
        this.body.setPos(0.0f, 0.0f, 0.0f);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelScale);
        this.legRight = new HideableModelRenderer((AdvancedEntityModel)this, 0, 16);
        this.legRight.setPos(-1.9f, 12.0f, 0.1f);
        this.legRight.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.armLeft = new HideableModelRenderer((AdvancedEntityModel)this, 40, 16);
        this.armLeft.mirror = true;
        this.armLeft.setPos(5.0f, 2.0f, -0.0f);
        this.armLeft.addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.setRotateAngle((AdvancedModelBox)this.armLeft, -0.0f, 0.10000736f, -0.10000736f);
        this.legLeft = new HideableModelRenderer((AdvancedEntityModel)this, 0, 16);
        this.legLeft.mirror = true;
        this.legLeft.setPos(1.9f, 12.0f, 0.1f);
        this.legLeft.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.head = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelScale);
        this.sleeveLeft = new HideableModelRenderer((AdvancedEntityModel)this, 35, 33);
        this.sleeveLeft.mirror = true;
        this.sleeveLeft.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveLeft.addBox(-1.0f, -2.1f, -2.5f, 5.0f, 6.0f, 5.0f, modelScale);
        this.robeLowerRight = new HideableModelRenderer((AdvancedEntityModel)this, 58, 33);
        this.robeLowerRight.mirror = true;
        this.robeLowerRight.setPos(0.0f, -0.2f, 0.0f);
        this.robeLowerRight.addBox(-2.1f, 0.0f, -2.5f, 4.0f, 7.0f, 5.0f, modelScale);
        this.cloak = new HideableModelRenderer((AdvancedEntityModel)this, 81, 37);
        this.cloak.setPos(0.0f, 0.1f, 0.0f);
        this.cloak.addBox(-4.5f, 0.0f, 2.3f, 9.0f, 21.0f, 1.0f, modelScale);
        this.setRotateAngle((AdvancedModelBox)this.cloak, 0.045553092f, 0.0f, 0.0f);
        this.armRight = new HideableModelRenderer((AdvancedEntityModel)this, 40, 16);
        this.armRight.setPos(-5.0f, 2.0f, 0.0f);
        this.armRight.addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.setRotateAngle((AdvancedModelBox)this.armRight, -0.0f, -0.10000736f, 0.10000736f);
        this.robeLowerLeft = new HideableModelRenderer((AdvancedEntityModel)this, 58, 33);
        this.robeLowerLeft.setPos(0.0f, -0.2f, 0.0f);
        this.robeLowerLeft.addBox(-1.9f, 0.0f, -2.5f, 4.0f, 7.0f, 5.0f, modelScale);
        this.armRight.addChild((BasicModelPart)this.sleeveRight);
        this.body.addChild((BasicModelPart)this.chestplate);
        this.head.addChild((BasicModelPart)this.crown);
        this.body.addChild((BasicModelPart)this.legRight);
        this.body.addChild((BasicModelPart)this.armLeft);
        this.body.addChild((BasicModelPart)this.legLeft);
        this.body.addChild((BasicModelPart)this.head);
        this.armLeft.addChild((BasicModelPart)this.sleeveLeft);
        this.legRight.addChild((BasicModelPart)this.robeLowerRight);
        this.body.addChild((BasicModelPart)this.cloak);
        this.body.addChild((BasicModelPart)this.armRight);
        this.legLeft.addChild((BasicModelPart)this.robeLowerLeft);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void animateModel(EntityDreadKnight entity, float limbAngle, float limbDistance, float tickDelta) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemstack.getItem() == Items.BOW && entity.swinging) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((Entity)entity, limbAngle, limbDistance, tickDelta);
    }

    @Override
    public void setRotationAnglesSpawn(EntityDreadKnight entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void animate(EntityDreadKnight entity, float f, float f1, float f2, float f3, float f4, float f5) {
    }

    @Override
    public Animation getSpawnAnimation() {
        return EntityDreadKnight.ANIMATION_SPAWN;
    }

    public void copyPropertiesTo(EntityModel<EntityDreadKnight> model) {
        super.copyPropertiesTo(model);
        if (model instanceof HumanoidModel) {
            HumanoidModel bipedEntityModel = (HumanoidModel)model;
            bipedEntityModel.leftArmPose = this.leftArmPose;
            bipedEntityModel.rightArmPose = this.rightArmPose;
            bipedEntityModel.crouching = this.isSneak;
        }
    }
}

