/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.render.entity.RenderHydra;
import com.iafenvoy.iceandfire.render.model.ModelHydraBody;
import com.iafenvoy.iceandfire.render.model.ModelHydraHead;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class LayerHydraHead
extends RenderLayer<EntityHydra, ModelHydraBody> {
    public static final ResourceLocation TEXTURE_STONE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hydra/stone.png");
    private static final float[][] TRANSLATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.3f, 0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.4f, -0.1f, 0.1f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.5f, -0.2f, 0.0f, 0.2f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.1f, 0.2f, 0.4f, 0.6f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f}};
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    private static final ModelHydraHead[] modelArr = new ModelHydraHead[9];
    private final RenderHydra renderer;

    public LayerHydraHead(RenderHydra renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
    }

    public static void renderHydraHeads(ModelHydraBody model, boolean stone, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityHydra hydra, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.pushPose();
        int heads = hydra.getHeadCount();
        LayerHydraHead.translateToBody(model, matrixStackIn);
        RenderType type = RenderType.entityCutout((ResourceLocation)(stone ? TEXTURE_STONE : LayerHydraHead.getHeadTexture(hydra)));
        for (int head = 1; head <= heads; ++head) {
            matrixStackIn.pushPose();
            float bodyWidth = 0.5f;
            matrixStackIn.translate(TRANSLATE[heads - 1][head - 1] * bodyWidth, 0.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(ROTATE[heads - 1][head - 1]));
            modelArr[head - 1].setAngles(hydra, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            modelArr[head - 1].renderToBuffer(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)hydra, (float)0.0f), -1);
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
    }

    public static ResourceLocation getHeadTexture(EntityHydra gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> RenderHydra.TEXUTURE_1;
            case 2 -> RenderHydra.TEXUTURE_2;
            default -> RenderHydra.TEXUTURE_0;
        };
    }

    protected static void translateToBody(ModelHydraBody model, PoseStack stack) {
        LayerHydraHead.postRender(model.BodyUpper, stack);
    }

    protected static void postRender(AdvancedModelBox renderer, PoseStack matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f) {
                matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            }
        } else {
            matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.mulPose(Axis.ZP.rotation(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.mulPose(Axis.YP.rotation(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.mulPose(Axis.XP.rotation(renderer.rotateAngleX));
            }
        }
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityHydra entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isInvisible()) {
            return;
        }
        LayerHydraHead.renderHydraHeads((ModelHydraBody)this.renderer.getModel(), false, matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    public ResourceLocation getTexture(EntityHydra gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> RenderHydra.TEXUTURE_1;
            case 2 -> RenderHydra.TEXUTURE_2;
            default -> RenderHydra.TEXUTURE_0;
        };
    }

    static {
        for (int i = 0; i < modelArr.length; ++i) {
            LayerHydraHead.modelArr[i] = new ModelHydraHead(i);
        }
    }
}

