/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.render.entity.RenderTideTrident;
import com.iafenvoy.iceandfire.render.model.ModelTideTrident;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RenderTideTridentItem
extends BlockEntityWithoutLevelRenderer {
    private static final ModelTideTrident MODEL = new ModelTideTrident();

    public RenderTideTridentItem(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelLoader) {
        super(dispatcher, modelLoader);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext type, PoseStack stackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        stackIn.translate(0.5f, 0.5f, 0.5f);
        if (type == ItemDisplayContext.GUI || type == ItemDisplayContext.FIXED || type == ItemDisplayContext.NONE || type == ItemDisplayContext.GROUND) {
            ItemStack tridentInventory = new ItemStack((ItemLike)IafItems.TIDE_TRIDENT_INVENTORY.get());
            if (stack.isEnchanted()) {
                tridentInventory.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)));
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(tridentInventory, type, type == ItemDisplayContext.GROUND ? combinedLightIn : 240, combinedOverlayIn, stackIn, bufferIn, (Level)Minecraft.getInstance().level, 0);
        } else {
            stackIn.pushPose();
            stackIn.translate(0.0f, 0.2f, -0.15f);
            if (type.firstPerson()) {
                stackIn.translate(type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND ? -0.3f : 0.3f, 0.2f, -0.2f);
            } else {
                stackIn.translate(0.0f, 0.6f, 0.0f);
            }
            stackIn.mulPose(Axis.XP.rotationDegrees(160.0f));
            VertexConsumer glintVertexBuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)RenderTideTrident.TRIDENT), (boolean)false, (boolean)stack.hasFoil());
            MODEL.renderToBuffer(stackIn, glintVertexBuilder, combinedLightIn, combinedOverlayIn, -1);
            stackIn.popPose();
        }
    }
}

