/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.block;

import com.iafenvoy.iceandfire.entity.block.BlockEntityPixieHouse;
import com.iafenvoy.iceandfire.item.block.BlockPixieHouse;
import com.iafenvoy.iceandfire.render.block.RenderJar;
import com.iafenvoy.iceandfire.render.model.ModelPixie;
import com.iafenvoy.iceandfire.render.model.ModelPixieHouse;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderPixieHouse<T extends BlockEntityPixieHouse>
implements BlockEntityRenderer<T> {
    private static final ModelPixieHouse MODEL = new ModelPixieHouse();
    private static final RenderType TEXTURE_0 = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/pixie/house/pixie_house_0.png"), (boolean)false);
    private static final RenderType TEXTURE_1 = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/pixie/house/pixie_house_1.png"), (boolean)false);
    private static final RenderType TEXTURE_2 = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/pixie/house/pixie_house_2.png"), (boolean)false);
    private static final RenderType TEXTURE_3 = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/pixie/house/pixie_house_3.png"), (boolean)false);
    private static final RenderType TEXTURE_4 = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/pixie/house/pixie_house_4.png"), (boolean)false);
    private static final RenderType TEXTURE_5 = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/pixie/house/pixie_house_5.png"), (boolean)false);
    private static ModelPixie MODEL_PIXIE;
    public BlockItem metaOverride;

    public RenderPixieHouse(BlockEntityRendererProvider.Context context) {
    }

    public void render(T entity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int rotation = 0;
        int meta = 0;
        if (MODEL_PIXIE == null) {
            MODEL_PIXIE = new ModelPixie();
        }
        if (entity != null && entity.getLevel() != null && entity.getLevel().getBlockState(entity.getBlockPos()).getBlock() instanceof BlockPixieHouse) {
            meta = BlockEntityPixieHouse.getHouseTypeFromBlock(entity.getLevel().getBlockState(entity.getBlockPos()).getBlock());
            if (!entity.getLevel().getBlockState(entity.getBlockPos()).hasProperty((Property)BlockPixieHouse.FACING)) {
                return;
            }
            Direction facing = (Direction)entity.getLevel().getBlockState(entity.getBlockPos()).getValue((Property)BlockPixieHouse.FACING);
            if (facing == Direction.NORTH) {
                rotation = 180;
            } else if (facing == Direction.EAST) {
                rotation = -90;
            } else if (facing == Direction.WEST) {
                rotation = 90;
            }
        }
        if (entity == null) {
            meta = BlockEntityPixieHouse.getHouseTypeFromBlock(this.metaOverride.getBlock());
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5f, 1.501f, 0.5f);
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)rotation));
        if (entity != null && entity.getLevel() != null && ((BlockEntityPixieHouse)((Object)entity)).hasPixie) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, 0.95f, 0.0f);
            matrixStackIn.scale(0.55f, 0.55f, 0.55f);
            matrixStackIn.pushPose();
            RenderType type = switch (((BlockEntityPixieHouse)((Object)entity)).pixieType) {
                case 1 -> RenderJar.TEXTURE_1;
                case 2 -> RenderJar.TEXTURE_2;
                case 3 -> RenderJar.TEXTURE_3;
                case 4 -> RenderJar.TEXTURE_4;
                case 5 -> RenderJar.TEXTURE_5;
                default -> RenderJar.TEXTURE_0;
            };
            RenderType type2 = switch (((BlockEntityPixieHouse)((Object)entity)).pixieType) {
                case 1 -> RenderJar.TEXTURE_1_GLO;
                case 2 -> RenderJar.TEXTURE_2_GLO;
                case 3 -> RenderJar.TEXTURE_3_GLO;
                case 4 -> RenderJar.TEXTURE_4_GLO;
                case 5 -> RenderJar.TEXTURE_5_GLO;
                default -> RenderJar.TEXTURE_0_GLO;
            };
            matrixStackIn.pushPose();
            MODEL_PIXIE.animateInHouse((BlockEntityPixieHouse)((Object)entity));
            MODEL_PIXIE.renderToBuffer(matrixStackIn, bufferIn.getBuffer(type), combinedLightIn, combinedOverlayIn, -1);
            MODEL_PIXIE.renderToBuffer(matrixStackIn, bufferIn.getBuffer(type2), combinedLightIn, combinedOverlayIn, -1);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
        RenderType pixieType = switch (meta) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case 3 -> TEXTURE_3;
            case 4 -> TEXTURE_4;
            case 5 -> TEXTURE_5;
            default -> TEXTURE_0;
        };
        matrixStackIn.pushPose();
        MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(pixieType), combinedLightIn, combinedOverlayIn, -1);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }
}

