/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.armor;

import com.iafenvoy.iceandfire.registry.IafArmorMaterials;
import com.iafenvoy.iceandfire.render.model.armor.ModelDragonSteelFireArmor;
import com.iafenvoy.iceandfire.render.model.armor.ModelDragonSteelIceArmor;
import com.iafenvoy.iceandfire.render.model.armor.ModelDragonSteelLightningArmor;
import com.iafenvoy.uranus.client.render.armor.IArmorRendererBase;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DragonSteelArmorRenderer
implements IArmorRendererBase<LivingEntity> {
    public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<LivingEntity> bipedEntityModel) {
        boolean inner = armorSlot == EquipmentSlot.LEGS || armorSlot == EquipmentSlot.HEAD;
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ArmorMaterial armorMaterial = (ArmorMaterial)armorItem.getMaterial().value();
            if (((ArmorMaterial)IafArmorMaterials.DRAGONSTEEL_FIRE_ARMOR_MATERIAL.value()).equals((Object)armorMaterial)) {
                return new ModelDragonSteelFireArmor(inner);
            }
            if (((ArmorMaterial)IafArmorMaterials.DRAGONSTEEL_ICE_ARMOR_MATERIAL.value()).equals((Object)armorMaterial)) {
                return new ModelDragonSteelIceArmor(inner);
            }
            if (((ArmorMaterial)IafArmorMaterials.DRAGONSTEEL_LIGHTNING_ARMOR_MATERIAL.value()).equals((Object)armorMaterial)) {
                return new ModelDragonSteelLightningArmor(inner);
            }
        }
        return null;
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot) {
        ArmorMaterial material = (ArmorMaterial)((ArmorItem)stack.getItem()).getMaterial().value();
        if (material == IafArmorMaterials.DRAGONSTEEL_FIRE_ARMOR_MATERIAL.value()) {
            return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/armor/armor_dragonsteel_fire" + (slot == EquipmentSlot.LEGS ? "_legs.png" : ".png")));
        }
        if (material == IafArmorMaterials.DRAGONSTEEL_ICE_ARMOR_MATERIAL.value()) {
            return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/armor/armor_dragonsteel_ice" + (slot == EquipmentSlot.LEGS ? "_legs.png" : ".png")));
        }
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/armor/armor_dragonsteel_lightning" + (slot == EquipmentSlot.LEGS ? "_legs.png" : ".png")));
    }
}

