/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.component.DragonHornComponent;
import com.iafenvoy.iceandfire.component.DragonSkullComponent;
import com.iafenvoy.iceandfire.component.StoneStatusComponent;
import com.mojang.serialization.Codec;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;

public final class IafDataComponents {
    public static final DeferredRegister<DataComponentType<?>> REGISTRY = DeferredRegister.create((String)"iceandfire", (ResourceKey)Registries.DATA_COMPONENT_TYPE);
    public static final RegistrySupplier<DataComponentType<Integer>> INT = IafDataComponents.register("int", DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final RegistrySupplier<DataComponentType<Boolean>> BOOL = IafDataComponents.register("bool", DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final RegistrySupplier<DataComponentType<String>> STRING = IafDataComponents.register("string", DataComponentType.builder().persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
    public static final RegistrySupplier<DataComponentType<UUID>> UUID = IafDataComponents.register("uuid", DataComponentType.builder().persistent(UUIDUtil.AUTHLIB_CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC));
    public static final RegistrySupplier<DataComponentType<CompoundTag>> NBT_COMPOUND = IafDataComponents.register("nbt_compound", DataComponentType.builder().persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.fromCodec((Codec)CompoundTag.CODEC)));
    public static final RegistrySupplier<DataComponentType<List<String>>> BESTIARY_PAGES = IafDataComponents.register("bestiary_pages", DataComponentType.builder().persistent(Codec.STRING.listOf()).networkSynchronized(ByteBufCodecs.fromCodec((Codec)Codec.STRING.listOf())));
    public static final RegistrySupplier<DataComponentType<DragonHornComponent>> DRAGON_HORN = IafDataComponents.register("dragon_horn", DataComponentType.builder().persistent(DragonHornComponent.CODEC).networkSynchronized(ByteBufCodecs.fromCodec(DragonHornComponent.CODEC)));
    public static final RegistrySupplier<DataComponentType<DragonSkullComponent>> DRAGON_SKULL = IafDataComponents.register("dragon_skull", DataComponentType.builder().persistent(DragonSkullComponent.CODEC).networkSynchronized(ByteBufCodecs.fromCodec(DragonSkullComponent.CODEC)));
    public static final RegistrySupplier<DataComponentType<StoneStatusComponent>> STONE_STATUS = IafDataComponents.register("stone_status", DataComponentType.builder().persistent(StoneStatusComponent.CODEC).networkSynchronized(ByteBufCodecs.fromCodec(StoneStatusComponent.CODEC)));

    public static <T> RegistrySupplier<DataComponentType<T>> register(String id, DataComponentType.Builder<T> builder) {
        return REGISTRY.register(id, () -> builder.build());
    }
}

