/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.component.DragonHornComponent;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemDragonHorn
extends Item {
    public ItemDragonHorn() {
        super(new Item.Properties().stacksTo(1));
    }

    public static int getDragonType(ItemStack stack) {
        Optional optional;
        if (stack.has((DataComponentType)IafDataComponents.DRAGON_HORN.get()) && (optional = BuiltInRegistries.ENTITY_TYPE.getOptional(((DragonHornComponent)stack.get((DataComponentType)IafDataComponents.DRAGON_HORN.get())).entityType())).isPresent()) {
            EntityType entityType = (EntityType)optional.get();
            if (entityType == IafEntities.FIRE_DRAGON.get()) {
                return 1;
            }
            if (entityType == IafEntities.ICE_DRAGON.get()) {
                return 2;
            }
            if (entityType == IafEntities.LIGHTNING_DRAGON.get()) {
                return 3;
            }
        }
        return 0;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        EntityDragonBase dragon;
        ItemStack trueStack = playerIn.getItemInHand(hand);
        if (!playerIn.level().isClientSide && trueStack.is((Item)this) && !stack.has((DataComponentType)IafDataComponents.DRAGON_HORN.get()) && target instanceof EntityDragonBase && (dragon = (EntityDragonBase)target).isOwnedBy((LivingEntity)playerIn)) {
            CompoundTag entityTag = new CompoundTag();
            target.save(entityTag);
            trueStack.set((DataComponentType)IafDataComponents.DRAGON_HORN.get(), (Object)new DragonHornComponent(BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()), target.getUUID(), entityTag));
            playerIn.swing(hand);
            playerIn.level().playSound(playerIn, playerIn.blockPosition(), SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.NEUTRAL, 3.0f, 0.75f);
            target.remove(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getClickedFace() != Direction.UP) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (stack.has((DataComponentType)IafDataComponents.DRAGON_HORN.get())) {
            DragonHornComponent component = (DragonHornComponent)stack.get((DataComponentType)IafDataComponents.DRAGON_HORN.get());
            Level world = context.getLevel();
            EntityType type = BuiltInRegistries.ENTITY_TYPE.getOptional(component.entityType()).orElse(null);
            if (type != null) {
                UUID uuid;
                Entity entity = type.create(world);
                if (entity instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)entity;
                    dragon.load(component.entityData());
                }
                if ((uuid = component.entityUuid()) != null) {
                    assert (entity != null);
                    entity.setUUID(uuid);
                }
                assert (entity != null);
                entity.absMoveTo((double)context.getClickedPos().getX() + 0.5, (double)(context.getClickedPos().getY() + 1), (double)context.getClickedPos().getZ() + 0.5, 180.0f + context.getHorizontalDirection().toYRot(), 0.0f);
                if (world.addFreshEntity(entity)) {
                    stack.remove((DataComponentType)IafDataComponents.DRAGON_HORN.get());
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Optional optional;
        DragonHornComponent component;
        CompoundTag entityTag;
        super.appendHoverText(stack, context, tooltip, type);
        if (stack.has((DataComponentType)IafDataComponents.DRAGON_HORN.get()) && !(entityTag = (component = (DragonHornComponent)stack.get((DataComponentType)IafDataComponents.DRAGON_HORN.get())).entityData()).isEmpty() && (optional = BuiltInRegistries.ENTITY_TYPE.getOptional(component.entityType())).isPresent()) {
            EntityType entityType = (EntityType)optional.get();
            tooltip.add((Component)Component.translatable((String)entityType.getDescriptionId()).withStyle(this.getTextColorForEntityType(entityType)));
            String name = Component.translatable((String)"dragon.unnamed").getString();
            if (!entityTag.getString("CustomName").isEmpty()) {
                name = entityTag.getString("CustomName");
            }
            tooltip.add((Component)Component.literal((String)name).withStyle(ChatFormatting.GRAY));
            String gender = Component.translatable((String)"dragon.gender").getString() + " " + Component.translatable((String)(entityTag.getBoolean("Gender") ? "dragon.gender.male" : "dragon.gender.female")).getString();
            tooltip.add((Component)Component.literal((String)gender).withStyle(ChatFormatting.GRAY));
            int stagenumber = entityTag.getInt("AgeTicks") / 24000;
            int stage1 = stagenumber >= 100 ? 5 : (stagenumber >= 75 ? 4 : (stagenumber >= 50 ? 3 : (stagenumber >= 25 ? 2 : 1)));
            tooltip.add((Component)Component.translatable((String)"dragon.stage").append((Component)Component.literal((String)(" " + stage1 + " "))).append((Component)Component.translatable((String)"dragon.days.front")).append((Component)Component.literal((String)(stagenumber + " "))).append((Component)Component.translatable((String)"dragon.days.back")).withStyle(ChatFormatting.GRAY));
        }
    }

    private ChatFormatting getTextColorForEntityType(EntityType<?> type) {
        if (type == IafEntities.FIRE_DRAGON.get()) {
            return ChatFormatting.DARK_RED;
        }
        if (type == IafEntities.ICE_DRAGON.get()) {
            return ChatFormatting.BLUE;
        }
        if (type == IafEntities.LIGHTNING_DRAGON.get()) {
            return ChatFormatting.DARK_PURPLE;
        }
        return ChatFormatting.GRAY;
    }
}

