/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.pathfinding;

import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.entity.pathfinding.NodeProcessorDeathWorm;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PathNavigateDeathWormSand
extends WaterBoundPathNavigation {
    public PathNavigateDeathWormSand(EntityDeathWorm deathworm, Level worldIn) {
        super((Mob)deathworm, worldIn);
    }

    public boolean canFloat() {
        return this.nodeEvaluator.canFloat();
    }

    protected PathFinder createPathFinder(int i) {
        this.nodeEvaluator = new NodeProcessorDeathWorm();
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.setCanFloat(true);
        return new PathFinder(this.nodeEvaluator, i);
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY() + 0.5, this.mob.getZ());
    }

    protected boolean canMoveDirectly(Vec3 start, Vec3 end) {
        BlockHitResult raytraceresult = this.level.clip((ClipContext)new CustomRayTraceContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            Vec3 vec3i = raytraceresult.getLocation();
            return this.mob.level().getBlockState(BlockPos.containing((Position)vec3i)).is(BlockTags.SAND);
        }
        return raytraceresult.getType() == HitResult.Type.MISS;
    }

    public boolean isStableDestination(BlockPos pos) {
        return this.level.getBlockState(pos).canOcclude();
    }

    public static class CustomRayTraceContext
    extends ClipContext {
        private final ClipContext.Block blockMode;
        private final CollisionContext context;

        public CustomRayTraceContext(Vec3 startVecIn, Vec3 endVecIn, ClipContext.Block blockModeIn, ClipContext.Fluid fluidModeIn, Entity entityIn) {
            super(startVecIn, endVecIn, blockModeIn, fluidModeIn, entityIn);
            this.blockMode = blockModeIn;
            this.context = CollisionContext.of((Entity)entityIn);
        }

        public VoxelShape getBlockShape(BlockState blockState, BlockGetter world, BlockPos pos) {
            if (blockState.is(BlockTags.SAND)) {
                return Shapes.empty();
            }
            return this.blockMode.get(blockState, world, pos, this.context);
        }
    }
}

