/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class DragonAITargetNonTamed<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final EntityDragonBase dragon;

    public DragonAITargetNonTamed(EntityDragonBase entityIn, Class<T> classTarget, boolean checkSight, Predicate<LivingEntity> targetSelector) {
        super((Mob)entityIn, classTarget, 5, checkSight, false, targetSelector);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.dragon = entityIn;
    }

    public boolean canUse() {
        if (this.dragon.isTame()) {
            return false;
        }
        if (this.dragon.lookingForRoostAIFlag) {
            return false;
        }
        boolean canUse = super.canUse();
        boolean isSleeping = this.dragon.isSleeping();
        if (canUse) {
            if (isSleeping && this.target instanceof Player) {
                return this.dragon.distanceToSqr((Entity)this.target) <= 16.0;
            }
            return !isSleeping;
        }
        return false;
    }

    protected AABB getTargetSearchArea(double targetDistance) {
        return this.dragon.getBoundingBox().inflate(targetDistance, targetDistance, targetDistance);
    }

    protected double getFollowDistance() {
        AttributeInstance iattributeinstance = this.mob.getAttribute(Attributes.FOLLOW_RANGE);
        return iattributeinstance == null ? 128.0 : iattributeinstance.getValue();
    }
}

