/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDragonLightningCharge;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonDestructionManager;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityLightningDragon
extends EntityDragonBase {
    public static final ResourceLocation FEMALE_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/dragon/lightning_dragon_female");
    public static final ResourceLocation MALE_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/dragon/lightning_dragon_male");
    public static final ResourceLocation SKELETON_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/dragon/lightning_dragon_skeleton");
    private static final EntityDataAccessor<Boolean> HAS_LIGHTNING_TARGET = SynchedEntityData.defineId(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> LIGHTNING_TARGET_X = SynchedEntityData.defineId(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> LIGHTNING_TARGET_Y = SynchedEntityData.defineId(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> LIGHTNING_TARGET_Z = SynchedEntityData.defineId(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public EntityLightningDragon(EntityType<? extends EntityLightningDragon> t, Level worldIn) {
        super(t, worldIn, DragonType.LIGHTNING, 1.0, 1 + (Integer)IafCommonConfig.INSTANCE.dragon.attackDamage.getValue(), (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue() * 0.04, (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue(), 0.15f, 0.4f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)30);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_LIGHTNING_TARGET, (Object)false);
        builder.define(LIGHTNING_TARGET_X, (Object)Float.valueOf(0.0f));
        builder.define(LIGHTNING_TARGET_Y, (Object)Float.valueOf(0.0f));
        builder.define(LIGHTNING_TARGET_Z, (Object)Float.valueOf(0.0f));
    }

    @Override
    public int getStartMetaForType() {
        return 8;
    }

    @Override
    protected boolean shouldTarget(Entity entity) {
        if (entity instanceof EntityDragonBase && !this.isTame()) {
            return entity.getType() != this.getType() && this.getBbWidth() >= entity.getBbWidth() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof Player || DragonUtils.isDragonTargetable(entity, IafEntityTags.LIGHTNING_DRAGON_TARGETS) || !this.isTame() && DragonUtils.isVillager(entity);
    }

    @Override
    public boolean isTimeToWake() {
        return !this.level().isDay() || this.getCommand() == 2;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    public String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "amethyst_";
            case 2 -> "copper_";
            case 3 -> "black_";
            default -> "electric_";
        };
    }

    public boolean isInvulnerableTo(DamageSource i) {
        if (i.getMsgId().equals(this.level().damageSources().lightningBolt().getMsgId())) {
            this.heal(15.0f);
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 20, 1));
            return true;
        }
        return super.isInvulnerableTo(i);
    }

    public void setHasLightningTarget(boolean lightning_target) {
        this.entityData.set(HAS_LIGHTNING_TARGET, (Object)lightning_target);
    }

    public boolean hasLightningTarget() {
        return (Boolean)this.entityData.get(HAS_LIGHTNING_TARGET);
    }

    public void setLightningTargetVec(float x, float y, float z) {
        this.entityData.set(LIGHTNING_TARGET_X, (Object)Float.valueOf(x));
        this.entityData.set(LIGHTNING_TARGET_Y, (Object)Float.valueOf(y));
        this.entityData.set(LIGHTNING_TARGET_Z, (Object)Float.valueOf(z));
    }

    public float getLightningTargetX() {
        return ((Float)this.entityData.get(LIGHTNING_TARGET_X)).floatValue();
    }

    public float getLightningTargetY() {
        return ((Float)this.entityData.get(LIGHTNING_TARGET_Y)).floatValue();
    }

    public float getLightningTargetZ() {
        return ((Float)this.entityData.get(LIGHTNING_TARGET_Z)).floatValue();
    }

    @Override
    public boolean doHurtTarget(Entity entityIn) {
        this.getLookControl().setLookAt(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0), entityIn.position().add(0.0, (double)(entityIn.getBbHeight() / 2.0f), 0.0)) && entityIn.getBbWidth() < this.getBbWidth() * 0.5f && this.getControllingPassenger() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.startRiding((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        LivingEntity attackTarget = this.getTarget();
        if (!this.level().isClientSide && attackTarget != null) {
            if (this.getBoundingBox().inflate((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).intersects(attackTarget.getBoundingBox())) {
                this.doHurtTarget((Entity)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.onGround())) {
                this.shootFireAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.distanceToSqr((Entity)attackTarget) < 100.0) {
                double difX = attackTarget.getX() - this.getX();
                double difY = attackTarget.getY() + (double)attackTarget.getBbHeight() - this.getY();
                double difZ = attackTarget.getZ() - this.getZ();
                this.setDeltaMovement(this.getDeltaMovement().add(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.getBoundingBox().inflate((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).intersects(attackTarget.getBoundingBox())) {
                    this.doHurtTarget((Entity)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
        if (!this.isBreathingFire()) {
            this.setHasLightningTarget(false);
        }
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.setYRot(this.yBodyRot);
                if (this.fireBreathTicks % 7 == 0) {
                    this.playSound((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.getX() + 0.5f, (float)burningTarget.getY() + 0.5f, (float)burningTarget.getZ() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.getRandom().nextInt(5) == 0 && !this.isBaby()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.setYRot(this.yBodyRot);
                Vec3 headVec = this.getHeadPosition();
                this.playSound((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH_CRACKLE.get(), 4.0f, 1.0f);
                double d2 = controller.getLookAngle().x;
                double d3 = controller.getLookAngle().y;
                double d4 = controller.getLookAngle().z;
                float inaccuracy = 1.0f;
                EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.LIGHTNING_DRAGON_CHARGE.get()), this.level(), this, d2 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.setPos(headVec.x, headVec.y, headVec.z);
                if (!this.level().isClientSide) {
                    this.level().addFreshEntity((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                HitResult mop;
                this.setYRot(this.yBodyRot);
                if (this.fireBreathTicks % 7 == 0) {
                    this.playSound((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.getLocation().x, mop.getLocation().y, mop.getLocation().z, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public Item getBloodItem() {
        return (Item)IafItems.LIGHTNING_DRAGON_BLOOD.get();
    }

    @Override
    public Item getFleshItem() {
        return (Item)IafItems.LIGHTNING_DRAGON_FLESH.get();
    }

    @Override
    public ItemLike getHeartItem() {
        return (ItemLike)IafItems.LIGHTNING_DRAGON_HEART.get();
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(LivingEntity entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.getRandom().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 20) {
                    this.setYRot(this.yBodyRot);
                    Vec3 headVec = this.getHeadPosition();
                    double d2 = entity.getX() - headVec.x;
                    double d3 = entity.getY() - headVec.y;
                    double d4 = entity.getZ() - headVec.z;
                    float inaccuracy = 1.0f;
                    this.playSound((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                    EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.LIGHTNING_DRAGON_CHARGE.get()), this.level(), this, d2 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.setPos(headVec.x, headVec.y, headVec.z);
                    if (!this.level().isClientSide) {
                        this.level().addFreshEntity((Entity)entitylargefireball);
                    }
                    if (!entity.isAlive()) {
                        this.setBreathingFire(false);
                    }
                    this.randomizeAttacks();
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.setYRot(this.yBodyRot);
                    if (this.tickCount % 5 == 0) {
                        this.playSound((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.getX(), entity.getY(), entity.getZ(), 1);
                    if (!entity.isAlive()) {
                        this.setBreathingFire(false);
                        this.randomizeAttacks();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.lookAt((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (((IafEvents.DragonFire)IafEvents.ON_DRAGON_FIRE_BLOCK.invoker()).onFireBlock(this, burnX, burnY, burnZ)) {
            return;
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.setYRot(this.yBodyRot);
                Vec3 headVec = this.getHeadPosition();
                double d2 = burnX - headVec.x;
                double d3 = burnY - headVec.y;
                double d4 = burnZ - headVec.z;
                float inaccuracy = 1.0f;
                this.playSound((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH_CRACKLE.get(), 4.0f, 1.0f);
                EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.LIGHTNING_DRAGON_CHARGE.get()), this.level(), this, d2 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.setPos(headVec.x, headVec.y, headVec.z);
                if (!this.level().isClientSide) {
                    this.level().addFreshEntity((Entity)entitylargefireball);
                }
            }
            return;
        }
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vec3 headPos = this.getHeadPosition();
        double d2 = burnX - headPos.x;
        double d3 = burnY - headPos.y;
        double d4 = burnZ - headPos.z;
        double distance = Math.max(2.5 * Math.sqrt(this.distanceToSqr(burnX, burnY, burnZ)), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.x + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.y + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.z + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                this.setHasLightningTarget(true);
                this.setLightningTargetVec((float)burnX, (float)burnY, (float)burnZ);
            } else if (!this.level().isClientSide) {
                BlockHitResult result = this.level().clip(new ClipContext(new Vec3(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ()), new Vec3(progressX, progressY, progressZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                Vec3 vec3 = result.getLocation();
                BlockPos pos = BlockPos.containing((Position)vec3);
                IafDragonDestructionManager.destroyAreaBreath(this.level(), pos, this);
                this.setHasLightningTarget(true);
                this.setLightningTargetVec((float)result.getLocation().x, (float)result.getLocation().y, (float)result.getLocation().z);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.random.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.random.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.random.nextFloat() * 3.0 - 1.5;
            this.setHasLightningTarget(true);
            this.setLightningTargetVec((float)spawnX, (float)spawnY, (float)spawnZ);
            if (!this.level().isClientSide) {
                IafDragonDestructionManager.destroyAreaBreath(this.level(), BlockPos.containing((double)spawnX, (double)spawnY, (double)spawnZ), this);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_IDLE.get() : (this.isMature() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_IDLE.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_IDLE.get());
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_HURT.get() : (this.isMature() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_HURT.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_HURT.get());
    }

    protected SoundEvent getDeathSound() {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_DEATH.get() : (this.isMature() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_DEATH.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_DEATH.get());
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_ROAR.get() : (this.isMature() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_ROAR.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_ROAR.get());
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT, ANIMATION_SPEAK, ANIMATION_BITE, ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR, ANIMATION_EPIC_ROAR};
    }

    public boolean isFood(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() != null && stack.getItem() == IafItems.LIGHTNING_STEW.get();
    }

    @Override
    protected void spawnDeathParticles() {
        for (int k = 0; k < 3; ++k) {
            double d2 = this.random.nextGaussian() * 0.02;
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            if (!this.level().isClientSide) continue;
            this.level().addParticle((ParticleOptions)ParticleTypes.RAIN, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d2, d0, d1);
        }
    }

    @Override
    public void spawnBabyParticles() {
        for (int i = 0; i < 5; ++i) {
            float radiusAdd = (float)i * 0.15f;
            float headPosX = (float)(this.getX() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.cos((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
            float headPosZ = (float)(this.getY() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.sin((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
            float headPosY = (float)(this.getZ() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Item getSkull() {
        return (Item)IafItems.DRAGON_SKULL_LIGHTNING.get();
    }
}

