/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDreadBeast;
import com.iafenvoy.iceandfire.entity.EntityDreadGhoul;
import com.iafenvoy.iceandfire.entity.EntityDreadHorse;
import com.iafenvoy.iceandfire.entity.EntityDreadLich;
import com.iafenvoy.iceandfire.entity.EntityDreadScuttler;
import com.iafenvoy.iceandfire.entity.EntityDreadThrall;
import com.iafenvoy.iceandfire.entity.util.IDreadMob;
import com.iafenvoy.iceandfire.entity.util.IHumanoid;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityDreadMob
extends Monster
implements IDreadMob {
    protected static final EntityDataAccessor<Optional<UUID>> COMMANDER_UNIQUE_ID = SynchedEntityData.defineId(EntityDreadMob.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public EntityDreadMob(EntityType<? extends Monster> t, Level worldIn) {
        super(t, worldIn);
    }

    public static Entity necromancyEntity(LivingEntity entity) {
        if (entity.getType().is(EntityTypeTags.ARTHROPOD)) {
            EntityDreadScuttler lichSummoned = new EntityDreadScuttler((EntityType<? extends EntityDreadScuttler>)((EntityType)IafEntities.DREAD_SCUTTLER.get()), entity.level());
            float readInScale = entity.getBbWidth() / 1.5f;
            Level level = entity.level();
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverWorldAccess = (ServerLevelAccessor)level;
                lichSummoned.finalizeSpawn(serverWorldAccess, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setSize(readInScale);
            return lichSummoned;
        }
        if (entity instanceof Zombie || entity instanceof IHumanoid) {
            EntityDreadGhoul lichSummoned = new EntityDreadGhoul((EntityType<? extends EntityDreadGhoul>)((EntityType)IafEntities.DREAD_GHOUL.get()), entity.level());
            float readInScale = entity.getBbWidth() / 0.6f;
            Level level = entity.level();
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverWorldAccess = (ServerLevelAccessor)level;
                lichSummoned.finalizeSpawn(serverWorldAccess, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setSize(readInScale);
            return lichSummoned;
        }
        if (entity.getType().is(EntityTypeTags.UNDEAD) || entity instanceof AbstractSkeleton || entity instanceof Player) {
            EntityDreadThrall lichSummoned = new EntityDreadThrall((EntityType<? extends EntityDreadThrall>)((EntityType)IafEntities.DREAD_THRALL.get()), entity.level());
            Level serverWorldAccess = entity.level();
            if (serverWorldAccess instanceof ServerLevelAccessor) {
                EquipmentSlot[] serverWorldAccess2 = (EquipmentSlot[])serverWorldAccess;
                lichSummoned.finalizeSpawn((ServerLevelAccessor)serverWorldAccess2, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setCustomArmorHead(false);
            lichSummoned.setCustomArmorChest(false);
            lichSummoned.setCustomArmorLegs(false);
            lichSummoned.setCustomArmorFeet(false);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                lichSummoned.setItemSlot(slot, entity.getItemBySlot(slot));
            }
            return lichSummoned;
        }
        if (entity instanceof AbstractHorse) {
            return new EntityDreadHorse((EntityType<? extends EntityDreadHorse>)((EntityType)IafEntities.DREAD_HORSE.get()), entity.level());
        }
        if (entity instanceof Animal) {
            EntityDreadBeast lichSummoned = new EntityDreadBeast((EntityType<? extends EntityDreadBeast>)((EntityType)IafEntities.DREAD_BEAST.get()), entity.level());
            float readInScale = entity.getBbWidth() / 1.2f;
            Level level = entity.level();
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverWorldAccess = (ServerLevelAccessor)level;
                lichSummoned.finalizeSpawn(serverWorldAccess, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setSize(readInScale);
            return lichSummoned;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COMMANDER_UNIQUE_ID, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getCommanderId() != null) {
            compound.putUUID("CommanderUUID", this.getCommanderId());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("CommanderUUID")) {
            uuid = compound.getUUID("CommanderUUID");
        } else {
            String s = compound.getString("CommanderUUID");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setCommanderId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isAlliedTo(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.isAlliedTo(entityIn);
    }

    public UUID getCommanderId() {
        return ((Optional)this.entityData.get(COMMANDER_UNIQUE_ID)).orElse(null);
    }

    public void setCommanderId(UUID uuid) {
        this.entityData.set(COMMANDER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public void aiStep() {
        EntityDreadLich lich;
        Entity entity;
        super.aiStep();
        if (!this.level().isClientSide && (entity = this.getCommander()) instanceof EntityDreadLich && (lich = (EntityDreadLich)entity).getTarget() != null && lich.getTarget().isAlive()) {
            this.setTarget(lich.getTarget());
        }
    }

    @Override
    public Entity getCommander() {
        try {
            Entity entity;
            Player player;
            UUID uuid = this.getCommanderId();
            Player player2 = player = uuid == null ? null : this.level().getPlayerByUUID(uuid);
            if (player != null) {
                return player;
            }
            if (!this.level().isClientSide && (entity = this.level().getServer().getLevel(this.level().dimension()).getEntity(uuid)) instanceof LivingEntity) {
                return entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public void onKillEntity(LivingEntity LivingEntityIn) {
        Entity summoned;
        EntityDreadMob commander;
        EntityDreadMob entityDreadMob = commander = this instanceof EntityDreadLich ? this : this.getCommander();
        if (commander != null && !(LivingEntityIn instanceof EntityDragonBase) && (summoned = EntityDreadMob.necromancyEntity(LivingEntityIn)) != null) {
            summoned.copyPosition((Entity)LivingEntityIn);
            if (!this.level().isClientSide) {
                this.level().addFreshEntity(summoned);
            }
            if (commander instanceof EntityDreadLich) {
                EntityDreadLich lich = (EntityDreadLich)commander;
                lich.setMinionCount(lich.getMinionCount() + 1);
            }
            if (summoned instanceof EntityDreadMob) {
                EntityDreadMob mob = (EntityDreadMob)summoned;
                mob.setCommanderId(commander.getUUID());
            }
        }
    }

    public void remove(Entity.RemovalReason reason) {
        Entity entity;
        if (!this.isRemoved() && this.getCommander() != null && (entity = this.getCommander()) instanceof EntityDreadLich) {
            EntityDreadLich lich = (EntityDreadLich)entity;
            lich.setMinionCount(lich.getMinionCount() - 1);
        }
        super.remove(reason);
    }
}

