/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.ChainData;
import com.iafenvoy.iceandfire.data.component.ChickenData;
import com.iafenvoy.iceandfire.data.component.FrozenData;
import com.iafenvoy.iceandfire.data.component.MiscData;
import com.iafenvoy.iceandfire.data.component.SirenData;
import com.iafenvoy.iceandfire.impl.ComponentManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class IafEntityData {
    public final FrozenData frozenData = new FrozenData();
    public final ChainData chainData = new ChainData();
    public final SirenData sirenData = new SirenData();
    public final ChickenData chickenData = new ChickenData();
    public final MiscData miscData = new MiscData();
    private final LivingEntity entity;
    private boolean isDirty = false;

    public IafEntityData(LivingEntity entity) {
        this.entity = entity;
    }

    public void deserialize(@NotNull CompoundTag tag) {
        this.frozenData.deserialize(tag);
        this.chainData.deserialize(tag);
        this.sirenData.deserialize(tag);
        this.chickenData.deserialize(tag);
        this.miscData.deserialize(tag);
    }

    public void serialize(@NotNull CompoundTag tag) {
        this.frozenData.serialize(tag);
        this.chainData.serialize(tag);
        this.sirenData.serialize(tag);
        this.chickenData.serialize(tag);
        this.miscData.serialize(tag);
    }

    public void tick() {
        this.frozenData.tickFrozen(this.entity);
        this.chainData.tickChain(this.entity);
        this.sirenData.tickCharmed(this.entity);
        this.chickenData.tickChicken(this.entity);
        this.miscData.tickMisc(this.entity);
        this.isDirty = this.frozenData.doesClientNeedUpdate() || this.chainData.doesClientNeedUpdate() || this.sirenData.doesClientNeedUpdate() || this.miscData.doesClientNeedUpdate();
    }

    public boolean isDirty() {
        boolean d = this.isDirty;
        this.isDirty = false;
        return d;
    }

    public static IafEntityData get(LivingEntity living) {
        return ComponentManager.getIafEntityData(living);
    }
}

